<?php

/**
 * @file
 * Provides the admin callback functionalities
 */

module_load_include('inc', 'beididp_checkrole');

/**
 * Callbacks for the admin settings
 */
function beididp_checkrole_form($form, &$form_state) {
  $form['#tree'] = TRUE;

  $form['beididp_required_for_role'] = array(
    '#type' => 'fieldset',
    '#title' => t('Roles that require eID authentication'),
    '#description' => t('Check roles that require eID authentication. Users within these roles will only be able to log in using their eID.'),
    '#collapsible' => TRUE,
    '#collapsed' => FALSE,
    '#weight' => -10,
  );

  // Don't include Drupal's anonymous role.
  $roles = user_roles(TRUE);
  $required = variable_get('beididp_required_for_role', array());

  foreach ($roles as $rid => $name) {
    $form['beididp_required_for_role'][$rid] = array(
      '#type' => 'checkbox',
      '#title' => check_plain(t($name)),
      '#default_value' => !empty($required[$rid]),
    );
  }

  $form['beididp_checkrole_admin_bypass'] = array(
    '#type' => 'checkbox',
    '#title' => t('Admin can always log in with password'),
    '#description' => t('Drupal admin (uid 1) can always log in with username and password, even if eID is mandatory.'),
    '#default_value' => variable_get('beididp_checkrole_admin_bypass', TRUE),
    '#weight' => -9,
  );

  return system_settings_form($form);
}

/**
  * Form validation handler for beididp_checkrole_form().
  *
  * Prevents that the admin will be locked out if he has no eID identity.
  */
function beididp_checkrole_form_validate($form, &$form_state) {
  global $user;

  $role_ids = array_keys($form_state['values']['beididp_required_for_role'], 1);
  $bypass = $form_state['values']['beididp_checkrole_admin_bypass'];

  if (beididp_checkrole_would_lock_user(1, $role_ids) && !$bypass) {
    form_set_error('beididp_required_for_role', t('The administrator has a role that would require eID login, but the account does not have an eID. Not saved.'));
  }
  // In case the beididp configurator is not the admin user
  if ($user->uid != 1) {
    if (beididp_checkrole_would_lock_user($user->uid, $role_ids)) {
      form_set_error('beididp_required_for_role', t('You have a role that would require eID login, but your account does not have an eID. Not saved.'));
    }
  }
}
