<?php

namespace Drupal\best_selling_products\Service;

use Drupal\commerce_product\Entity\ProductInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Database\Driver\mysql\Connection;

/**
 * Class ProductsService.
 */
class ProductsService implements ProductsServiceInterface {

  /**
   * Drupal\Core\Entity\EntityTypeManagerInterface definition.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * Drupal\Core\Database\Driver\mysql\Connection definition.
   *
   * @var \Drupal\Core\Database\Driver\mysql\Connection
   */
  protected $database;

  /**
   * Constructs a new ProductService object.
   */
  public function __construct(EntityTypeManagerInterface $entity_type_manager, Connection $database) {
    $this->entityTypeManager = $entity_type_manager;
    $this->database = $database;
  }

  /**
   * {@inheritdoc}
   */
  public function bestSellingProducts($number_of_products) {
    $query = $this->database->select('commerce_order', 'co')
      ->fields('pvfd', ['product_id']);
    $count_field = $query->addExpression('COUNT(pvfd.product_id)', 'count');
    $query->leftJoin('commerce_order_item', 'coi', 'co.order_id=coi.order_id');
    $query->leftJoin('commerce_product_variation_field_data', 'pvfd', 'coi.purchased_entity=pvfd.variation_id');
    $query->condition('co.state', 'completed');
    $query->isNotNull('pvfd.product_id');
    $query->groupBy('pvfd.product_id');
    $query->orderBy($count_field, 'DESC');

    $product_ids = $query->execute()->fetchCol();

    $products = $this->isPublishedProducts($product_ids, $number_of_products);

    return $products;
  }

  /**
   * Get published products.
   */
  private function isPublishedProducts($product_ids, $number_of_products) {
    $products = [];
    foreach ($product_ids as $product_id) {
      /** @var \Drupal\commerce_order\Entity\Order $order */
      $product = $this->entityTypeManager->getStorage('commerce_product')
        ->load($product_id);

      if ($product instanceof ProductInterface && $product->isPublished()) {
        $products[$product->id()] = $product;
      }
      if (count($products) == $number_of_products) {
        break;
      }
    }
    return $products;
  }

}
