/**
 * Gulp tasks
 *
 * gulp sass: convert assets/src/scss/admin-tabs.scss into assets/dist/css/admin-tabs.css
 * gulp svg-min: minify all svg icons inside assets/src/icons into assets/dist/svg
 */

/**
 * plugins
 */
var gulp = require('gulp');
var sass = require('gulp-sass');
var svgmin = require('gulp-svgmin');

/**
 * configfile
 */

var config = {
  svg: {
    src: 'assets/src/icons/*.svg',
    dest: 'assets/dist/',
    settings: {
      shape: {
        dimension: { // Set maximum dimensions
          maxWidth: 30,
          maxHeight: 30
        },
        spacing: {
          padding: 0
        }
      },
      mode: {
        stack: {
          dest: '',
          sprite: 'sprites/admin-tabs.svg'
        }
      }
    }
  },
  sass: {
    src: 'assets/src/scss/admin-tabs.scss',
    dest: 'assets/dist/css',
    outputStyle: 'expanded'
  }

};

/**
 * Tasks
 */

gulp.task('sass', function () {
  'use strict';
  return gulp.src(config.sass.src)
    .pipe(sass({outputStyle: config.sass.outputStyle}).on('error', sass.logError))
    .pipe(gulp.dest(config.sass.dest));
});

gulp.task('svg-min', function () {
    return gulp.src(config.svg.src)
        .pipe(svgmin())
        .pipe(gulp.dest('assets/dist/svg'));
});
