<?php

function better_form_add_required_attr_fields(&$form_elements) {
  foreach (element_children($form_elements) as $element) {
    $current_element = &$form_elements[$element];
    if (!isset($current_element['#type']) || (isset($current_element['#required']) && $current_element['#required'] === FALSE)) {
      continue;
    }
    if ($current_element['#type'] === 'container' || !isset($current_element['#required'])) {
      //check on next nesting level
      better_form_add_required_attr_fields($current_element);
    }
    if ($current_element['#type'] == 'checkboxes' || $current_element['#type'] == 'radios') {
      $current_element['#attributes']['class'] = array('required-form-field');
      continue;
    }
    if ($element === LANGUAGE_NONE) {
      better_form_add_required_attribute($current_element[0]['value']);
      continue;
    }
    //add required attributes
    better_form_add_required_attribute($current_element);
  }      
} 

function better_form_add_required_attribute(&$form_elements) {
  $form_elements['#attributes']['required'] = 'required';
  $form_elements['#attributes']['title'] = t('This field is required!');
}

function better_form_add_placeholder_attr_fields(&$form_elements) {
  foreach (element_children($form_elements) as $element) {
    $current_element = &$form_elements[$element];
    if (isset($current_element['#title']) && !empty($current_element['#title'])) {
      if ($element == LANGUAGE_NONE) {
        better_form_add_placeholder_attribute($current_element[0]['value']);
        continue;
      }
      better_form_add_placeholder_attribute($current_element);
      continue;
    }
    else {
      better_form_add_placeholder_attr_fields($current_element);
    }
  }
}

function better_form_add_placeholder_attribute(&$form_elements) {
  if (empty($form_elements['#title'])) {
    return FALSE; 
  }
  $form_elements['#attributes']['placeholder'] = $form_elements['#title'];
}