<?php

function better_form_add_required_attribute_fields(&$form_elements) {
  $exception_fields = array('checkboxes', 'radios'); //check variable name
  foreach (element_children($form_elements) as $element) {
    $current_element = &$form_elements[$element];
    if (isset($current_element['#type'])) {
      if (isset($current_element['#required'])) {
        if ($current_element['#required'] == TRUE) {
          if (in_array($current_element['#type'], $exception_fields)) {
            _better_form_add_required_attribute_class_field($current_element);
            continue;
          }
          //add required attributes
          _better_form_add_required_attribute_field($current_element);
          continue;
        }
        else {
          //check next form element
          continue;
        }
      }
    }
    //check on next nesting level
    better_form_add_required_attribute_fields($current_element);
  }
} 

function _better_form_add_required_attribute_field(&$form_elements) {
  $form_elements['#attributes']['required'] = 'required';
  $form_elements['#attributes']['title'] = t('This field is required!');
}

function _better_form_add_required_attribute_class_field(&$form_element) {
  $form_element['#attributes']['class'][] = 'required-form-field';
}

function better_form_add_placeholder_attribute_fields(&$form_elements) {
  foreach (element_children($form_elements) as $element) {
    $current_element = &$form_elements[$element];
    if (isset($current_element['#title'])) {
      if ($current_element['#title']) {
        //add required attributes
        _better_form_add_placeholder_attribute_field($current_element);
        continue;
      }
      else {
        //check next form element
        continue;
      }
    }
    //check on next nesting level
    better_form_add_placeholder_attribute_fields($current_element);
  }
}

function _better_form_add_placeholder_attribute_field(&$form_elements) {
  if (empty($form_elements['#title'])) {
    return FALSE;
  }
  $form_elements['#attributes']['placeholder'] = $form_elements['#title'];
}