<?php

/**
 * @file
 * Part of the "Better Form Errors" module that will be included for
 * displaying help.
 */

/**
 * Implemens hook_help().
 *
 * https://api.drupal.org/
 *  api/drupal/modules!system!system.api.php/function/hook_help/7
 */
function better_form_errors_help($path, $arg) {
  $readme = 'README.txt';
  $readme_menu_item = 'admin/better_form_errors/readme';
  switch ($path) {

    case 'admin/help#better_form_errors':
      $link_module = l(
        BETTER_FORM_ERRORS_MODULE_FULLNAME,
        BETTER_FORM_ERRORS_MODULE_HOMEPAGE,
        array(
          'attributes' => array(
            'target' => '_blank',
            'title' => t('Homepage') . ' ' . t('of module') . ' "' . BETTER_FORM_ERRORS_MODULE_FULLNAME . '"',
          ),
        )
      );
      $link_author = l(
        BETTER_FORM_ERRORS_AUTHOR_NAME,
        BETTER_FORM_ERRORS_AUTHOR_HOMEPAGE,
        array(
          'attributes' => array(
            'target' => '_blank',
            'title' => t('Author') . ' ' . t('of module') . ' "' . BETTER_FORM_ERRORS_MODULE_FULLNAME . '"',
          ),
        )
      );
      $image_demo = theme(
        'image',
        array(
          'path' => BETTER_FORM_ERRORS_MY_URL . 'img/better_form_errors.demo.png',
          'width' => '680',
          'height' => '210',
          'alt' => t('Drupal form validation error message example'),
          'title' => t('Demonstration') . ' ' . t('of module') . ' "' . BETTER_FORM_ERRORS_MODULE_FULLNAME . '"',
          'attributes' => array(
            'class' => 'img-demo',
          ),
        )
      );
      $link_readme = l(
        $readme,
        $readme_menu_item,
        array(
          'attributes' => array(
            'title' => $readme . ' ' . t('of module') . ' "' . BETTER_FORM_ERRORS_MODULE_FULLNAME . '"',
          ),
        )
      );

      $placeholders = array(
        '!link_module' => $link_module,
        '!link_author' => $link_author,
        '!link_readme' => $link_readme,
      );

      $return = "\n" . '<p>' . t(
        "Welcome to the Help page of Drupal's !link_module module, developed by !link_author.",
        $placeholders
      ) . '</p>';
      $return .= '<p>' . $image_demo . '</p>';
      $return .= '<p>' . t(
        "Complete documentation is available in the module's !link_readme file.",
        $placeholders
      ) . '</p>';
      if (BETTER_FORM_ERRORS_TEMP_PATH) {
        $return .= '<p>Content of error messages is written into directory <code>';
        $return .= BETTER_FORM_ERRORS_TEMP_PATH . '</code></p>';
      }
      drupal_add_css(BETTER_FORM_ERRORS_MY_URL . 'css/better_form_errors.help.css', array(
        'media' => 'screen, print',
        )
      );
      return $return;

    case $readme_menu_item:
      $path_readme = BETTER_FORM_ERRORS_MY_PATH . $readme;
      if (is_readable($path_readme)) {
        $contents_readme = file_get_contents($path_readme);
        if (!drupal_strlen($contents_readme)) {
          $contents_readme = t('Error') . ': ' . t('Getting content of file failed!');
        }
      }
      else {
        $contents_readme = t('Error') . ': ' . t('File is not readable!');
      }
      drupal_add_css(BETTER_FORM_ERRORS_MY_URL . 'css/better_form_errors.help.css', array(
        'media' => 'screen, print',
        )
      );
      $return = "\n" . '<p><pre class="pre-readme">' . check_plain($contents_readme) . '</pre></p>';
      return $return;
  }
}
