<?php

/**
 * @file
 * Part of the "Better Form Errors" module that will be included for
 * registering pathes.
 */

/**
 * Implements hook_menu().
 *
 * https://api.drupal.org/
 *  api/drupal/modules!system!system.api.php/function/hook_menu/7
 */
function better_form_errors_menu() {
  $items = array();
  // Item 1:
  $items['admin/better_form_errors/readme'] = array(
    'file' => 'includes/better_form_errors.menu.inc',
    'page callback' => '_better_form_errors_readme',
    'access arguments' => array('administer modules'),
    'type' => MENU_CALLBACK,
    'title' => BETTER_FORM_ERRORS_MODULE_FULLNAME . ': README.txt',
    'title callback' => FALSE,
  );
  return $items;
}

/**
 * Page callback function for Item 1 of function above.
 */
function _better_form_errors_readme() {
  $link_help = l(
    BETTER_FORM_ERRORS_MODULE_FULLNAME,
    'admin/help/better_form_errors',
    array(
      'attributes' => array(
        'title' => t('Help') . ' ' . t('for the module') . ' "' . BETTER_FORM_ERRORS_MODULE_FULLNAME . '"',
      ),
    )
  );

  $placeholders = array(
    '!link_help' => $link_help,
  );

  $return = "\n" . '<p><ul><li>' . t('Help') . ' ' . t('for the module') . ' ' . $link_help . '</li></ul></p>';
  return $return;
}
