<?php

/**
 * @file
 * Part of the "Better Form Errors" module that will be included for
 * catching error messages in the language of code "de" (German).
 */

/**
 * Helper function to catch an existing Drupal form validation error message.
 *
 * @return string
 *   The error message to set.
 */
function _better_form_errors_catch_message($message, $lang) {
  // Strings from core's "includes/form.inc":
  // Translation source:
  // msgid "!name field is required."
  // -> "drupal-7.35.de.po":
  // msgstr "Das Feld „!name” ist erforderlich."
  if (preg_match('/^(Das Feld )(.+)( ist erforderlich\.)$/', $message, $matches)) {
    $intro = $matches[1];
    $field = $matches[2];
    $explanation = $matches[3];
    $message = better_form_errors_compose_message($intro, $field, $explanation, $lang);
  }
  // Translation source:
  // msgid "!name cannot be longer than %max characters but is currently \
  // %length characters long."
  // -> "drupal-7.35.de.po":
  // msgstr "!name darf nicht länger als %max Zeichen sein, ist aber momentan \
  // %length Zeichen lang."
  elseif (preg_match('/^(.+)( darf nicht länger als \<em class="placeholder"\>\d+\<\/em\> Zeichen sein, ist aber momentan \<em class="placeholder"\>\d+\<\/em\> Zeichen lang\.)$/', $message, $matches)) {
    $field = $matches[1];
    $explanation = $matches[2];
    $message = better_form_errors_compose_message($intro, $field, $explanation, $lang);
  }
  // Webform Grid field having "Unique" enabled ("webform/components/grid.inc"):
  // Translation source:
  // msgid "!title is not allowed to have the same answer for more than one \
  // question."
  // -> "webform-7.x-4.8.de.po": MISSING STRING!
  elseif (preg_match('/^(.+)( is not allowed to have the same answer for more than one question\.)$/', $message, $matches)) {
    $field = $matches[1];
    $explanation = $matches[2];
    $message = better_form_errors_compose_message($intro, $field, $explanation, $lang);
  }
  return $message;
}
