<?php

/**
 * @file
 * Hooks provided by the "Better Form Errors" module.
 */

/**
 * Override the default error message replacement rules.
 *
 * Allows to set custom error messages in the language of the active interface.
 *
 * @param string $message
 *   The original Drupal form validation error message.
 * @param string $lang
 *   The language code representing the active interface language.
 *
 * @return string
 *   The new error message to replace the original one,
 *   or NULL if the module's built-in replacement rules should be used.
 */
function hook_better_form_errors_catch_message($message, $lang) {
  switch ($lang) {

    case 'de':
      // Replacement rules for German
      // Translation source:
      // msgid "!name field is required."
      if (preg_match('/^(Das Feld )(.+)( ist erforderlich\.)$/', $message, $matches)) {
        $message = NULL;
        // Don't override default rules.
      }
      // Translation source:
      // msgid "!name cannot be longer than %max characters but is currently \
      // %length characters long."
      elseif (preg_match('/^(.+)( darf nicht länger als \<em class="placeholder"\>\d+\<\/em\> Zeichen sein, ist aber momentan \<em class="placeholder"\>\d+\<\/em\> Zeichen lang\.)$/', $message, $matches)) {
        $message = NULL;
        // Don't override default rules.
      }
      // Translation source:
      // msgid "!title is not allowed to have the same answer for more than \
      // one question."
      elseif (preg_match('/^(In )(.+)( darf dieselbe Antwort nur einmal vergeben werden\.)$/', $message, $matches)) {
        $intro = $matches[1];
        $field = $matches[2];
        $explanation = $matches[3];
        $message = better_form_errors_compose_message($intro, $field, $explanation, $lang);
      }
      break;

    case 'fr':
      // Replacement rules for French...
      break;

    default:
      // Use the "Better Form Errors" module's built-in replacement rules for
      // all other languages:
      $message = NULL;
  }

  return $message;
}
