// $Id: better_messages.js,v 1.1 2009/07/21 13:36:29 doublethink Exp $

if (Drupal.jsEnabled) {	
	
	
	Drupal.behaviors.betterMessages = function (context) {
		var betterMessages = Drupal.settings.betterMessages;
		var message_box = $('#' + betterMessages.id);
		
		var vertical, horizontal = 0;
		switch (betterMessages.position) {
			case 'center':
				vertical = ( $(window).height() - message_box.height() ) / 2;
				horizontal = ( $(window).width() - message_box.width() ) / 2;
				message_box.css({"top":vertical + 'px', "left":horizontal + 'px'});
				break;
			case 'tl':
				vertical = 0; horizontal = 20;
				message_box.css({"top":vertical + 'px', "left":horizontal + 'px'});
				break;
			case 'tr':
				vertical = 0; horizontal = 20;
				message_box.css({"top":vertical + 'px', "right":horizontal + 'px'});
				break;
			case 'bl':
				vertical = 0; horizontal = 20;
				message_box.css({"bottom":vertical + 'px', "left":horizontal + 'px'});
				break;
			case 'br':
				vertical = 0; horizontal = 20;
				message_box.css({"bottom":vertical + 'px', "right":horizontal + 'px'});
				break;
		}

		betterMessages.fixed == '1' ? message_box.css({"position":"fixed"}) : message_box.css({"position":"absolute"});
		message_box.css({"width":betterMessages. width + 'px', "opacity": 0});
		
		//if (betterMessages.fixed != 0) { setTimeout(message_box.fadeOut(2000), 1000 ); }
		
		
		$('a.message-close').click(function() {
			message_box.fadeOut(betterMessages.popout.duration);
			return false;
		});
		
		message_box.fadeIn(betterMessages.popin.duration);
	}
}