(function ($, Drupal) {

  'use strict';

  Drupal.behaviors.betterPermissionsPage = {
    attach: (context) => {

      // Fire the logic only on page load when the context is the document.
      if (context == document) {
        // Get the hash fragment from the url.
        let hash = window.location.hash;
        // Get the provider module from the fragment.
        let provider = hash.replace(/#module-/g, "");
        // Check if there is such a provide in the select values.
        let providerExists = $('select[name="provider"] option[value="' + provider + '"]').length;

        // Set the option to the providers select if there is a fragment.
        if (providerExists) {
          $('select[name="provider"]').val(provider).change();
        }
      }
    }
  };

})(jQuery, Drupal);
