<?php
/**
 * @file
 * Contains \Drupal\better_revisions\Form\BetterRevisionsAdminForm.
 */
namespace Drupal\better_revisions\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

class BetterRevisionsAdminForm extends ConfigFormBase {

  public function getFormID() {
    return 'better_revisions_settings_form';
  }

  protected function getEditableConfigNames() {
    return [
      'better_revisions.settings',
    ];
  }

  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('better_revisions.settings');
    $form['br_require'] = array(
      '#type' => 'checkbox',
      '#title' => t('Require revision type selection'),
      '#default_value' => $config->get('br_require'),
      '#description' => t('Will only be required if <em>Create new revision</em> is checked.')
    );
    $form['br_list_title'] = array(
      '#type' => 'textfield',
      '#title' => 'Revision list title',
      '#default_value' => t($config->get('br_list_title')),
      '#required' => TRUE
    );
    $form['br_list_options'] = array(
      '#type' => 'textarea',
      '#title' => 'Revision list options',
      '#default_value' => t($config->get('br_list_options')),
      '#required' => TRUE,
      '#description' => 'Enter options, one per line'
    );
    $form['br_list_help'] = array(
      '#type' => 'textfield',
      '#title' => 'Revision list help text',
      '#default_value' => $config->get('br_list_help')
    );
    $form['br_add_txt'] = array(
      '#type' => 'radios',
      '#title' => t('Add an open text area for revision notes'),
      '#default_value' => $config->get('br_add_txt'),
      '#options' => array(
        0 => t('No'),
        1 => t('Yes (optional)'),
        2 => t('Yes (required)')
      )
    );
    $form['br_area_title'] = array(
      '#type' => 'textfield',
      '#title' => t('Title for the revision notes box'),
      '#default_value' => t($config->get('br_area_title')),
      '#states' => array(
        'visible' => array(
        array(':input[name="br_add_txt"]' => array('value' => 1)),
        array(':input[name="br_add_txt"]' => array('value' => 2)),
        )
      )
    );
    return parent::buildForm($form, $form_state);
  }

  public function submitForm(array &$form, FormStateInterface $form_state) {
    //\Drupal::config('betterrevisions.admin')
    $this->config('better_revisions.settings')
      ->set('br_require', $form_state->getValue('br_require'))
      ->set('br_list_title', $form_state->getValue('br_list_title'))
      ->set('br_list_options', $form_state->getValue('br_list_options'))
      ->set('br_list_help', $form_state->getValue('br_list_help'))
      ->set('br_add_txt', $form_state->getValue('br_add_txt'))
      ->set('br_area_title', $form_state->getValue('br_area_title'))
      ->save();
  }
}
?>