<?php

namespace Drupal\better_user_accounts\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * {@inheritdoc}
 */
class BetterUserAccountsSettings extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'better_user_accounts_settings';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->configFactory->get('better_user_accounts.settings');

    $form['labels'] = [
      '#type' => 'details',
      '#title' => $this->t('Custom labels'),
    ];
    $form['labels']['account_view_label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Custom account view label'),
      '#default_value' => $config->get('account_view_label'),
      '#description' => $this->t('Sets a custom label for the account view option. Leave empty to use the default label.'),
    ];

    $form['labels']['account_edit_label'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Custom account edit label'),
      '#default_value' => $config->get('account_edit_label'),
      '#description' => $this->t('Sets a custom label for the account edit option. Leave empty to use the default label.'),
    ];

    $form['edit_form'] = [
      '#type' => 'details',
      '#title' => $this->t('Account edit form'),
    ];
    $form['edit_form']['hide_unused_current_pass'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Hide obsolete current password field'),
      '#default_value' => $config->get('hide_unused_current_pass'),
      '#description' => $this->t('Hides the current password retype field from the account edit page, when it is not needed. This improves UX, because it\'s less confusing for users.'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('better_user_accounts.settings')
      ->set('account_view_label', $form_state->getValue('account_view_label'))
      ->set('account_edit_label', $form_state->getValue('account_edit_label'))
      ->set('hide_unused_current_pass', $form_state->getValue('hide_unused_current_pass'))
      ->save();
    parent::submitForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['better_user_accounts.settings'];
  }

}
