<?php

namespace Drupal\Tests\better_user_accounts\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * This class tests all functions that the Better User Accounts module provides.
 *
 * @group better_user_accounts
 */
class BetterUserAccountsFunctionsTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'better_user_accounts',
  ];

  /**
   * {@inheritDoc}
   *
   * @todo Check in core if we can get the tabs working without this heavy
   * installation profile!
   */
  protected $profile = 'standard';

  /**
   * A user with authenticated permissions.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $user;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->config('system.site')->set('page.front', '/test-page')->save();
    $this->user = $this->drupalCreateUser([]);
    $this->drupalLogin($this->rootUser);
  }

  /**
   * Tests the default account labels set by this module.
   */
  public function testDefaultOverriddenAccountLabels(): void {
    // Go to the settings page and change the account labels.
    $this->drupalGet('/admin/config/people/better-user-accounts');
    $session = $this->assertSession();
    $session->statusCodeEquals(200);
    $session->fieldValueEquals('account_view_label', 'Account');
    $session->fieldValueEquals('account_edit_label', 'Settings');
    // Go to the account edit page and make sure that the labels are changed.
    $this->drupalGet('/user/1/edit');
    $session->statusCodeEquals(200);
    // @todo Ensure this is not only on the page, but in the tabs!
    $session->pageTextContains('Account');
    $session->pageTextContains('Settings');
    // Go to the account page and make sure that the labels are changed.
    $this->drupalGet('/user/1');
    $session->statusCodeEquals(200);
    // @todo Ensure this is not only on the page, but in the tabs!
    $session->pageTextContains('Account');
    $session->pageTextContains('Settings');
  }

  /**
   * Tests changing the account labels to custom values.
   */
  public function testCustomOverriddenAccountLabels(): void {
    // Go to the settings page and change the account labels.
    $this->drupalGet('/admin/config/people/better-user-accounts');
    $session = $this->assertSession();
    $session->statusCodeEquals(200);
    $session->fieldValueEquals('account_view_label', 'Account');
    $session->fieldValueEquals('account_edit_label', 'Settings');
    $page = $this->getSession()->getPage();
    $page->fillField('account_view_label', 'View Profile');
    $page->fillField('account_edit_label', 'Edit Profile');
    $page->pressButton('edit-submit');
    $this->drupalGet('/admin/config/people/better-user-accounts');
    $session->statusCodeEquals(200);
    $session->fieldValueEquals('account_view_label', 'View Profile');
    $session->fieldValueEquals('account_edit_label', 'Edit Profile');
    // Go to the account edit page and make sure that the labels are changed.
    $this->drupalGet('/user/1/edit');
    $session->statusCodeEquals(200);
    // @todo Ensure this is not only on the page, but in the tabs!
    $session->pageTextContains('View Profile');
    $session->pageTextContains('Edit Profile');
    // Go to the account page and make sure that the labels are changed.
    $this->drupalGet('/user/1');
    $session->statusCodeEquals(200);
    // @todo Ensure this is not only on the page, but in the tabs!
    $session->pageTextContains('View Profile');
    $session->pageTextContains('Edit Profile');
  }

}
