<?php

namespace Drupal\Tests\better_user_accounts\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests the module settings.
 *
 * @group better_user_accounts
 */
class BetterUserAccountsSettingsTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'better_user_accounts',
  ];

  /**
   * A user with authenticated permissions.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $user;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->config('system.site')->set('page.front', '/test-page')->save();
    $this->user = $this->drupalCreateUser([]);
    $this->drupalLogin($this->rootUser);
  }

  /**
   * Tests the module settings.
   */
  public function testCustomOverriddenAccountLabels(): void {
    // Check the default config.
    $defaultConfig = \Drupal::config('better_user_accounts.settings');
    $session = $this->assertSession();
    $this->assertEquals($defaultConfig->get('account_view_label'), 'User account');
    $this->assertEquals($defaultConfig->get('account_edit_label'), 'Account settings');
    $this->assertFalse($defaultConfig->get('hide_unused_current_pass'));
    // Go to the settings page, check and change the account labels.
    $this->drupalGet('/admin/config/people/better-user-accounts');
    $session->statusCodeEquals(200);
    $session->fieldValueEquals('account_view_label', 'User account');
    $session->fieldValueEquals('account_edit_label', 'Account settings');
    $session->checkboxNotChecked('hide_unused_current_pass');
    $page = $this->getSession()->getPage();
    $page->fillField('account_view_label', 'View Profile');
    $page->fillField('account_edit_label', 'Edit Profile');
    $page->checkField('hide_unused_current_pass');
    $page->pressButton('edit-submit');
    $this->drupalGet('/admin/config/people/better-user-accounts');
    $session->statusCodeEquals(200);
    $session->fieldValueEquals('account_view_label', 'View Profile');
    $session->fieldValueEquals('account_edit_label', 'Edit Profile');
    $session->checkboxChecked('hide_unused_current_pass');
    // Evaluate new config values.
    $newConfig = \Drupal::config('better_user_accounts.settings');
    $this->assertEquals($newConfig->get('account_view_label'), 'View Profile');
    $this->assertEquals($newConfig->get('account_edit_label'), 'Edit Profile');
    $this->assertTrue($newConfig->get('hide_unused_current_pass'));
  }

}
