<?php

namespace Drupal\Tests\better_user_accounts\FunctionalJavascript;

use Drupal\FunctionalJavascriptTests\WebDriverTestBase;

/**
 * Tests the user account edit form functionality.
 *
 * @group better_user_accounts
 */
class BetterUserAccountsPasswordFieldTest extends WebDriverTestBase {

  /**
   * Modules to enable.
   *
   * @var array
   */
  protected static $modules = [
    'better_user_accounts',
    'user',
  ];

  /**
   * A user with admin permissions.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $adminUser;

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->config('system.site')->set('page.front', '/test-page')->save();
    $this->adminUser = $this->drupalCreateUser([]);
    $this->adminUser->addRole($this->createAdminRole('admin', 'admin'));
    $this->adminUser->save();
    $this->drupalLogin($this->adminUser);
  }

  /**
   * Tests the password field hiding functionality.
   */
  public function testPasswordFieldHide(): void {
    // Activate the password field functionality via config.
    \Drupal::configFactory()->getEditable('better_user_accounts.settings')->set('hide_unused_current_pass', TRUE)->save();
    // Go to the user account edit form and test the functionality.
    $this->drupalGet('/user/edit');
    $page = $this->getSession()->getPage();
    $session = $this->assertSession();
    $this->assertNull($session->waitForElementVisible('css', '#edit-current-pass', 500));
    $page->fillField('pass[pass1]', 'test');
    $this->assertNotNull($session->waitForElementVisible('css', '#edit-current-pass', 500));
    $page->fillField('pass[pass1]', '');
    $this->assertNull($session->waitForElementVisible('css', '#edit-current-pass', 500));
    $page->fillField('mail', 'test');
    $this->assertNotNull($session->waitForElementVisible('css', '#edit-current-pass', 500));
  }

}
