(function (Drupal) {
    Drupal.better_wishlist = Drupal.better_wishlist || [];
    Drupal.better_wishlist.reloadWishlists = () => {
      var storedUuidsString = localStorage.getItem('better_wishlists');
      var storedUuids = JSON.parse(storedUuidsString);
      var wishlist_uri = '/better-wishlist/wishlists?_format=json';
      if (storedUuids) {
        wishlist_uri = '/better-wishlist/wishlists?_format=json&uuids=' + storedUuids.join('+');
      }

      fetch(wishlist_uri)
        .then(response => response.json())
        .then(data => {
          document.querySelectorAll('.better-wishlist-add-to-wishlist-widget').forEach(widget => {
            var container = widget.querySelector('.better-wishlist-widget-toggle-container');
            container.querySelector('.better-wishlist-widget-wishlist-container').innerHTML = '';
            data.forEach(row => {
              var div = document.querySelector('.better-wishlist-widget-item').cloneNode(true);
              div.style.display = '';
              var link = document.createElement('a');
              link.href = '/wishlist/' + row.uuid + '/add-item?entity_type=' + widget.dataset.entityType + '&entity_id=' + widget.dataset.entityId;
              link.classList.add('use-ajax')

              if (row.items) {
                link.innerText = row.name + (' (' + row.items.length + ')');
                row.items.forEach((item) => {
                  if (widget.dataset.entityId == item.entity_id && widget.dataset.entityType == item.entity_type) {
                    div.classList.add('better-wishlist-already-on-list');
                  }
                });
              }
              else {
                link.innerText = row.name;
              }

              div.appendChild(link);
              container.querySelector('.better-wishlist-widget-wishlist-container').appendChild(div);
            })
            Drupal.attachBehaviors(container);
          })
          document.querySelectorAll('.better-wishlist-my-wishlists-list').forEach(list => {
            list.innerHTML = '';
            data.forEach(row => {
              var li = document.createElement('li');
              var link = document.createElement('a');
              link.innerText = row.name;
              link.href = '/wishlist/' + row.uuid;
              link.classList.add('use-ajax');
              link.dataset.dialogOptions = '{"width":800}';
              link.dataset.dialogType = 'modal';
              li.append(link);
              list.append(li);
            });
            Drupal.attachBehaviors(list);
          })
        })
    };

    Drupal.AjaxCommands.prototype.betterWishlistReloadWishlists = (ajax, response) => {
      Drupal.better_wishlist.reloadWishlists();
    }

    Drupal.behaviors.better_wishlist_widget = {
      attach: function (context) {
        context.querySelectorAll('.better-wishlist-add-to-wishlist-widget:not(.better-wishlist-processed)').forEach((element) => {
          element.classList.add('better-wishlist-processed')
          element.querySelector('a.better-wishlist-toggle').addEventListener('click', (e) => {
            e.preventDefault();
            var container = element.querySelector('.better-wishlist-widget-toggle-container');
            if (container.classList.contains('open')) {
              container.classList.remove('open');
              container.style.display = 'none';
            }
            else {
              Drupal.better_wishlist.reloadWishlists();
              container.classList.add('open');
              container.style.display = 'block';
            }
          });
        })
        document.querySelectorAll('body:not(.better-wishlist-processed)').forEach(body => {
          body.classList.add('better-wishlist-processed');
          Drupal.better_wishlist.reloadWishlists();
        });
      }
    }
  }
)
(Drupal)
