<?php

namespace Drupal\better_wishlist_widget\Controller;

use Drupal\better_wishlist_widget\Ajax\ReloadWishlistsCommand;
use Drupal\better_wishlist\Entity\WishlistInterface;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\MessageCommand;
use Drupal\Core\Controller\ControllerBase;
use Symfony\Component\HttpFoundation\Request;

/**
 * Controller for the wishlist widget.
 */
class WidgetController extends ControllerBase {

  /**
   * Adds an entity to a wishlist.
   *
   * @param \Drupal\better_wishlist\Entity\WishlistInterface $better_wishlist
   *   The wishlist.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request.
   *
   * @return \Drupal\Core\Ajax\AjaxResponse
   *   The response.
   */
  public function addEntityToWishlist(WishlistInterface $better_wishlist, Request $request) {

    $entity_type = $request->get('entity_type');
    $entity_id = $request->get('entity_id');

    if (empty($entity_type) || empty($entity_id)) {
      throw new \Exception($this->t('Missing parameters entity_type and entity_id'));
    }

    $entity = $this->entityTypeManager()
      ->getStorage($entity_type)
      ->load($entity_id);
    $added = $better_wishlist->addToWishlist($entity);
    $response = new AjaxResponse();
    $better_wishlist->save();
    if ($added) {
      $response->addCommand(new MessageCommand($this->t('Added :label to :wishlist_label.', [
        ':label' => $entity->label(),
        ':wishlist_label' => $better_wishlist->label(),
      ])));
    }

    $response->addCommand(new ReloadWishlistsCommand());
    return $response;
  }

  /**
   * Removes an entity from a wishlist.
   *
   * @param \Drupal\better_wishlist\Entity\WishlistInterface $better_wishlist
   *   The wishlist.
   * @param \Symfony\Component\HttpFoundation\Request $request
   *   The request.
   *
   * @return \Laminas\Diactoros\Response\RedirectResponse
   *   The response.
   */
  public function removeEntityFromWishlist(WishlistInterface $better_wishlist, Request $request) {
    $entity_type = $request->get('entity_type');
    $entity_id = $request->get('entity_id');

    if (empty($entity_type) || empty($entity_id)) {
      throw new \Exception($this->t('Missing parameters entity_type and entity_id'));
    }

    $entity = $this->entityTypeManager->getStorage($entity_type)
      ->load($entity_id);
    $removed = $better_wishlist->removeFromWishlist($entity);
    $response = new AjaxResponse();
    if ($removed) {
      $response->addCommand(new MessageCommand($this->t('Added :label to :wishlist_label.', [
        ':label' => $entity->label(),
        ':wishlist_label' => $better_wishlist->label(),
      ])));
    }
    $response->addCommand(new ReloadWishlistsCommand());
    return $response;
  }

}
