<?php

namespace Drupal\better_wishlist_widget\Form;

use Drupal\better_wishlist\Ajax\RegisterWishlistCommand;
use Drupal\better_wishlist\Form\WishlistForm;
use Drupal\better_wishlist_widget\Ajax\ReloadWishlistsCommand;
use Drupal\Core\Ajax\AjaxResponse;
use Drupal\Core\Ajax\CloseModalDialogCommand;
use Drupal\Core\Ajax\MessageCommand;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form class for the wishlist widget.
 */
class WishlistAjaxForm extends WishlistForm {

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $form = parent::buildForm($form, $form_state); // TODO: Change the autogenerated stub
    $form["actions"]["submit"]['#ajax'] = ['callback' => '::ajaxSubmit'];
    return $form;
  }

  /**
   * AJAX submit handler.
   *
   * @param array $form
   *   The form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The form state.
   *
   * @return \Drupal\Core\Ajax\AjaxResponse
   *   The response.
   */
  public function ajaxSubmit(array $form, FormStateInterface $form_state) {
    $this->submitForm($form, $form_state);
    $response = new AjaxResponse();
    $response->addCommand(new CloseModalDialogCommand());
    $response->addCommand(new MessageCommand($this->t('Created new wishlist :label', [':label' => $form_state->getValue('name')[0]['value']])));
    if ($this->currentUser()->isAnonymous()) {
      $response->addCommand(new RegisterWishlistCommand($this->entity->uuid()));
    }
    $response->addCommand(new ReloadWishlistsCommand());
    return $response;
  }

}
