<?php

namespace Drupal\better_wishlist;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\better_wishlist\Entity\WishlistItem;

/**
 * Provides dynamic permissions for Wishlist item of different types.
 *
 * @ingroup better_wishlist
 */
class WishlistItemPermissions {

  use StringTranslationTrait;

  /**
   * Returns an array of node type permissions.
   *
   * @return array
   *   The WishlistItem by bundle permissions.
   *   @see \Drupal\user\PermissionHandlerInterface::getPermissions()
   */
  public function generatePermissions() {
    return [];
  }

  /**
   * Returns a list of node permissions for a given node type.
   *
   * @param \Drupal\better_wishlist\Entity\WishlistItem $type
   *   The WishlistItem type.
   *
   * @return array
   *   An associative array of permission names and descriptions.
   */
  protected function buildPermissions(WishlistItem $type) {
    $type_id = $type->id();
    $type_params = ['%type_name' => $type->label()];

    return [
      "$type_id create entities" => [
        'title' => $this->t('Create new %type_name entities', $type_params),
      ],
      "$type_id edit own entities" => [
        'title' => $this->t('Edit own %type_name entities', $type_params),
      ],
      "$type_id edit any entities" => [
        'title' => $this->t('Edit any %type_name entities', $type_params),
      ],
      "$type_id delete own entities" => [
        'title' => $this->t('Delete own %type_name entities', $type_params),
      ],
      "$type_id delete any entities" => [
        'title' => $this->t('Delete any %type_name entities', $type_params),
      ],
    ];
  }

}
