/**
 * Manage showing Iframe instead of the normal JSON embed.
 */

(function ($, Drupal, drupalSettings) {
  Drupal.behaviors.betterembed = {
    attach: function (context, settings) {
      console.log(drupalSettings.betterEmbed.remotes);

      $('[data-betterembed-type="remote"] a', context)
        .once('attachIframeSwap')
        .each( function () {
          this.click( function () {
            var id = this.data('data-betterembed-type');
            $(
              '[data-betterembed-type="remote"][data-betterembed-id="' +
                id +
                '"]'
            ).remove();
          });
        });
    }
  };
})(jQuery, Drupal, drupalSettings);
