<?php
/**
 * Created by PhpStorm.
 * User: alex
 * Date: 14.12.18
 * Time: 16:19
 */

namespace Drupal\betterembed;

use Drupal\betterembed\Entity\BetterEmbedEntity;
use Drupal\Core\Config\Config;
use Drupal\Core\Config\ConfigFactoryInterface;
use GuzzleHttp\Client;
use Psr\Container\ContainerInterface;

class BetterEmbedManager {

  /**
   * Drupal\Core\Config\ConfigManager definition.
   *
   * @var \Drupal\Core\Config\Config
   */
  protected $config;
  /**
   * Constructs a new GlobalConfigForm object.
   */
  public function __construct(ConfigFactoryInterface $config_factory)
  {
    $this->config = $config_factory->get('betterembed.globalconfig');
  }

  public static function create(ContainerInterface $container)
  {
    return new static(
      $container->get('config.factory')
    );
  }

  /**
   * @{inheritdoc}
   */
  public function getConfig() {
    return $this->config;
  }

  /**
   * @{inheritdoc}
   */
  public function setConfig(Config $config) {
    $this->config = $config;
  }

  /**
   * @{inheritdoc}
   */
  public function getEmbed($url, array $config = []) {

    $entity = BetterEmbedEntity::loadByURL($url);

    if ($entity) {
      $entity = reset($entity);
    }
    else {
      $server_url = $this->config->get('betterembed.server_url') ?? "https://api.betterembed.com";
      $client = new Client(['base_uri' => $server_url]);
      $request = $client->request("GET", '/api/v0/item', ['query' => ['url' => $url]]);
      $status = $request->getStatusCode();
      $error = NULL;

      switch ($status) {
        case 200:
          $json = json_decode($request->getBody()->getContents());
          $entity = BetterEmbedEntity::createWithJson($url, $json);
          $entity->save();
          break;
        case 400:
          $json = json_decode($request->getBody()->getContents());
          $error = $json['detail'];
          break;
        case 429:
          $error = 'Rate Limit Reached';
          break;

        default:
          $error = json_decode($request->getBody()->getContents());
          break;
      }

      if (!empty($error)) {
        \Drupal::logger('BetterEmbed')->error("Couldn't create Embed from @url: @error", [ '@url' => $url, '@error' => $error ]);
      }
    }

    return $entity;
  }


  /**
   * @param \Drupal\Core\Datetime\DrupalDateTime $from
   * @param \Drupal\Core\Datetime\DrupalDateTime $until
   *
   * @return null
   */
  public function refreshBetterEmbeds(\Drupal\Core\Datetime\DrupalDateTime $from,
                                      \Drupal\Core\Datetime\DrupalDateTime $until) {
    /**
     * TODO - Although, doesnt make sense yet, since data changes very rarely
     */

    return NULL;
  }


}
