<?php

/**
 * @file
 * Contains \Drupal\url_embed\Plugin\Field\FieldFormatter\LinkEmbedFormatter.
 */

namespace Drupal\betterembed\Plugin\Field\FieldFormatter;

use Drupal\betterembed\BetterEmbedManager;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;
use Drupal\url_embed\UrlEmbedHelperTrait;
use Drupal\Component\Utility\Html;

/**
 * Plugin implementation of the 'url_embed' formatter.
 *
 * @FieldFormatter(
 *   id = "betterembed",
 *   label = @Translation("Better Embed"),
 *   field_types = {
 *     "link",
 *     "betterembed"
 *   }
 * )
 */
class BetterEmbedFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $element = array();

    foreach ($items as $delta => $item) {
      if ($url = $item->getUrl()->toString()) {
        try {

          $entity = \Drupal::service('betterembed')
            ->getEmbed(
              Html::decodeEntities($url)
            );

          if ($entity) {
            $view_mode = 'default'; // TODO - load config which display mode to use.
            $view_builder = \Drupal::entityTypeManager()->getViewBuilder('betterembed');
            $build = $view_builder->view($entity, $view_mode);
            $element[$delta] = $build;
          }
        }
        catch (\Exception $exception) {
          watchdog_exception('betterembed', $exception);
        }
      }
    }

    return $element;
  }

}
