<?php

/**
 * @file
 * Contains betterembed.page.inc.
 *
 * Page callback for Better Embed Entity entities.
 */

use Drupal\Core\Render\Element;

/**
 * Prepares variables for Better Embed Entity templates.
 *
 * Default template: betterembed.html.twig.
 *
 * @param array $variables
 *   An associative array containing:
 *   - elements: An associative array containing the user information and any
 *   - attributes: HTML attributes for the containing element.
 */
function template_preprocess_betterembed(array &$variables) {
  // Fetch BetterEmbedEntity Entity Object.
  $betterembed = $variables['elements']['#betterembed'];

  // Helpful $content variable for templates.
  foreach (Element::children($variables['elements']) as $key) {
    $variables['content'][$key] = $variables['elements'][$key];
  }
}
