<?php

namespace Drupal\betterembed;

use Drupal\Core\Entity\EntityAccessControlHandler;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Access\AccessResult;

/**
 * Access controller for the Better Embed Entity entity.
 *
 * @see \Drupal\betterembed\Entity\BetterEmbedEntity.
 */
class BetterEmbedEntityAccessControlHandler extends EntityAccessControlHandler {

  /**
   * {@inheritdoc}
   */
  protected function checkAccess(EntityInterface $entity, $operation, AccountInterface $account) {
    /** @var \Drupal\betterembed\Entity\BetterEmbedEntityInterface $entity */
    switch ($operation) {
      case 'view':
        if (!$entity->isPublished()) {
          return AccessResult::allowedIfHasPermission($account, 'view unpublished better embed entity entities');
        }
        return AccessResult::allowedIfHasPermission($account, 'view published better embed entity entities');

      case 'update':
        return AccessResult::allowedIfHasPermission($account, 'edit better embed entity entities');

      case 'delete':
        return AccessResult::allowedIfHasPermission($account, 'delete better embed entity entities');
    }

    // Unknown operation, no opinion.
    return AccessResult::neutral();
  }

  /**
   * {@inheritdoc}
   */
  protected function checkCreateAccess(AccountInterface $account, array $context, $entity_bundle = NULL) {
    return AccessResult::allowedIfHasPermission($account, 'add better embed entity entities');
  }

}
