<?php

namespace Drupal\betterembed;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;
use Drupal\Core\Link;

/**
 * Defines a class to build a listing of Better Embed Entity entities.
 *
 * @ingroup betterembed
 */
class BetterEmbedEntityListBuilder extends EntityListBuilder {


  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header['id'] = $this->t('Better Embed Entity ID');
    $header['name'] = $this->t('Name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /* @var $entity \Drupal\betterembed\Entity\BetterEmbedEntity */
    $row['id'] = $entity->id();
    $row['name'] = Link::createFromRoute(
      $entity->label(),
      'entity.betterembed.edit_form',
      ['betterembed' => $entity->id()]
    );
    return $row + parent::buildRow($entity);
  }

}
