<?php

namespace Drupal\betterembed;

use Drupal\Core\Entity\ContentEntityStorageInterface;
use Drupal\Core\Session\AccountInterface;
use Drupal\Core\Language\LanguageInterface;
use Drupal\betterembed\Entity\BetterEmbedEntityInterface;

/**
 * Defines the storage handler class for Better Embed Entity entities.
 *
 * This extends the base storage class, adding required special handling for
 * Better Embed Entity entities.
 *
 * @ingroup betterembed
 */
interface BetterEmbedEntityStorageInterface extends ContentEntityStorageInterface {

  /**
   * Gets a list of Better Embed Entity revision IDs for a specific Better Embed Entity.
   *
   * @param \Drupal\betterembed\Entity\BetterEmbedEntityInterface $entity
   *   The Better Embed Entity entity.
   *
   * @return int[]
   *   Better Embed Entity revision IDs (in ascending order).
   */
  public function revisionIds(BetterEmbedEntityInterface $entity);

  /**
   * Gets a list of revision IDs having a given user as Better Embed Entity author.
   *
   * @param \Drupal\Core\Session\AccountInterface $account
   *   The user entity.
   *
   * @return int[]
   *   Better Embed Entity revision IDs (in ascending order).
   */
  public function userRevisionIds(AccountInterface $account);

  /**
   * Counts the number of revisions in the default language.
   *
   * @param \Drupal\betterembed\Entity\BetterEmbedEntityInterface $entity
   *   The Better Embed Entity entity.
   *
   * @return int
   *   The number of revisions in the default language.
   */
  public function countDefaultLanguageRevisions(BetterEmbedEntityInterface $entity);

  /**
   * Unsets the language for all Better Embed Entity with the given language.
   *
   * @param \Drupal\Core\Language\LanguageInterface $language
   *   The language object.
   */
  public function clearRevisionsLanguage(LanguageInterface $language);

}
