<?php
/**
 * Created by PhpStorm.
 * User: alex
 * Date: 14.12.18
 * Time: 16:19
 */

namespace Drupal\betterembed;

use Drupal\Core\Config\Config;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use GuzzleHttp\Client;
use Psr\Container\ContainerInterface;

class BetterEmbedManager {

  /**
   * @var Config
   */
  protected $config;

  /**
   * @var EntityTypeManagerInterface
   */
  protected $manager;

  /**
   * Constructs a new GlobalConfigForm object.
   */
  public function __construct(ConfigFactoryInterface $config_factory, EntityTypeManagerInterface $manager)
  {
    $this->config = $config_factory->get('betterembed.globalconfig');
    $this->manager = $manager;
  }

  public static function create(ContainerInterface $container)
  {
    return new static(
      $container->get('config.factory'),
      $container->get('entity_type.manager')
    );
  }

  /**
   * @{inheritdoc}
   */
  public function getConfig() {
    return $this->config;
  }

  /**
   * @{inheritdoc}
   */
  public function setConfig(Config $config) {
    $this->config = $config;
  }

  /**
   * @{inheritdoc}
   */
  public function getEmbed($url, array $config = []) {

    $entity = $this->loadByURL($url);

    if ($entity) {
      $entity = reset($entity);
    }
    else {
      $server_url = $this->config->get('betterembed.server_url') ?? "https://api.betterembed.com";
      $client = new Client(['base_uri' => $server_url]);
      $request = $client->request("GET", '/api/v0/item', ['query' => ['url' => $url]]);
      $status = $request->getStatusCode();
      $error = NULL;

      // TODO: do some try / catch?
      switch ($status) {
        case 200:
          $json = json_decode($request->getBody()->getContents());
          $entity = $this->createWithJson($url, $json);
          if($entity) {
            $entity->save();
          }
          else {
            $error = 'Creation of Media entity failed';
          }
          break;
        case 400:
          $json = json_decode($request->getBody()->getContents());
          $error = $json['detail'];
          break;
        case 429:
          $error = 'Rate Limit Reached';
          break;

        default:
          $error = json_decode($request->getBody()->getContents());
          break;
      }

      if (!empty($error)) {
        \Drupal::logger('BetterEmbed')->error("Couldn't create Embed from @url: @error", [ '@url' => $url, '@error' => $error ]);
      }
    }

    return $entity;
  }

  /**
   * Load by URL
   */
  public function loadByURL($url) {
    // TODO: handle exception
    $storage = \Drupal::entityTypeManager()->getStorage('media');
    return $storage->loadByProperties([ 'name' => $url, 'bundle' => 'betterembed' ]);
  }

  public function createWithJson($name, $json) {
    $values = [];
    if (!is_array($json)) {
      $values = [
        'bundle'              => 'betterembed',
        'name'                => !empty($name)? $name : '',
        'field_embed_html'    => !empty($json->embedHtml)? $json->embedHtml : '',
        'field_url'           => !empty($json->url)? $json->url : '',
        'field_item_type'     => !empty($json->itemType)? $json->itemType : '',
        'field_title'         => !empty($json->title)? $json->title : '',
        'field_body'          => !empty($json->body)? $json->body : '',
        'field_thumbnail_url' => !empty($json->thumbnailUrl)? $json->thumbnailUrl : '',
        'field_author_name'   => !empty($json->authorName)? $json->authorName : '',
        'field_author_url'    => !empty($json->authorUrl)? $json->authorUrl : '',
        'field_response_json' => json_encode($json),
        // TODO - save in proper format
        //'field_published_at'  => !empty($json->publishedAt)? $json->publishedAt : '',
      ];
    }
    $storage = \Drupal::entityTypeManager()->getStorage('media');
    return $storage->create($values);
  }


  /**
   * @param \Drupal\Core\Datetime\DrupalDateTime $from
   * @param \Drupal\Core\Datetime\DrupalDateTime $until
   *
   * @return null
   */
  public function refreshBetterEmbeds(\Drupal\Core\Datetime\DrupalDateTime $from,
                                      \Drupal\Core\Datetime\DrupalDateTime $until) {
    /**
     * TODO - Although, doesnt make sense yet, since data changes very rarely
     */

    return NULL;
  }


}
