<?php

namespace Drupal\betterembed\Entity;

use Drupal\Core\Entity\RevisionLogInterface;
use Drupal\Core\Entity\RevisionableInterface;
use Drupal\Core\Entity\EntityChangedInterface;
use Drupal\user\EntityOwnerInterface;

/**
 * Provides an interface for defining Better Embed Entity entities.
 *
 * @ingroup betterembed
 */
interface BetterEmbedEntityInterface extends RevisionableInterface, RevisionLogInterface, EntityChangedInterface, EntityOwnerInterface {

  // Add get/set methods for your configuration properties here.

  /**
   * Gets the Better Embed Entity name.
   *
   * @return string
   *   Name of the Better Embed Entity.
   */
  public function getName();

  /**
   * Sets the Better Embed Entity name.
   *
   * @param string $name
   *   The Better Embed Entity name.
   *
   * @return \Drupal\betterembed\Entity\BetterEmbedEntityInterface
   *   The called Better Embed Entity entity.
   */
  public function setName($name);

  /**
   * Gets the Better Embed Entity creation timestamp.
   *
   * @return int
   *   Creation timestamp of the Better Embed Entity.
   */
  public function getCreatedTime();

  /**
   * Sets the Better Embed Entity creation timestamp.
   *
   * @param int $timestamp
   *   The Better Embed Entity creation timestamp.
   *
   * @return \Drupal\betterembed\Entity\BetterEmbedEntityInterface
   *   The called Better Embed Entity entity.
   */
  public function setCreatedTime($timestamp);

  /**
   * Returns the Better Embed Entity published status indicator.
   *
   * Unpublished Better Embed Entity are only visible to restricted users.
   *
   * @return bool
   *   TRUE if the Better Embed Entity is published.
   */
  public function isPublished();

  /**
   * Sets the published status of a Better Embed Entity.
   *
   * @param bool $published
   *   TRUE to set this Better Embed Entity to published, FALSE to set it to unpublished.
   *
   * @return \Drupal\betterembed\Entity\BetterEmbedEntityInterface
   *   The called Better Embed Entity entity.
   */
  public function setPublished($published);

  /**
   * Gets the Better Embed Entity revision creation timestamp.
   *
   * @return int
   *   The UNIX timestamp of when this revision was created.
   */
  public function getRevisionCreationTime();

  /**
   * Sets the Better Embed Entity revision creation timestamp.
   *
   * @param int $timestamp
   *   The UNIX timestamp of when this revision was created.
   *
   * @return \Drupal\betterembed\Entity\BetterEmbedEntityInterface
   *   The called Better Embed Entity entity.
   */
  public function setRevisionCreationTime($timestamp);

  /**
   * Gets the Better Embed Entity revision author.
   *
   * @return \Drupal\user\UserInterface
   *   The user entity for the revision author.
   */
  public function getRevisionUser();

  /**
   * Sets the Better Embed Entity revision author.
   *
   * @param int $uid
   *   The user ID of the revision author.
   *
   * @return \Drupal\betterembed\Entity\BetterEmbedEntityInterface
   *   The called Better Embed Entity entity.
   */
  public function setRevisionUserId($uid);

}
