<?php
/**
 * @file
 * Contains \Drupal\bibcite_import_orcid\Plugin\QueueWorker\OrcidQueue.
 */
namespace Drupal\bibcite_import_orcid\Plugin\QueueWorker;
use Drupal\Core\Queue\QueueWorkerBase;
/**
 * Processes ORCID data for every User in the DB using a QueueWorker.
 *
 * @QueueWorker(
 *   id = "queue_orcid",
 *   title = @Translation("ORCID Importer Queue Worker"),
 *   cron = {"time" = 60}
 * )
 */
class OrcidQueue extends QueueWorkerBase {
  /**
   * {@inheritdoc}
   */
  public function processItem($data) {

    $message = "ORCID Queue - Processing ".$data;
    \Drupal::logger('bibcite_import_orcid')->notice($message);

    $result = \Drupal::service("bibcite_import_orcid.importer")->importOrcidData($data);

    if (!$result){
        $message = "ORCID Queue - Error processing ".$data;
        \Drupal::logger('bibcite_import_orcid')->error($message);
    }else{
        $message = "ORCID Queue - Successfully imported ".$data;
        \Drupal::logger('bibcite_import_orcid')->notice($message);
    }
    
  }
}