<?php

namespace Drupal\bibcite_import_orcid\Controller;

use Drupal\Core\Session\AccountInterface;
use Symfony\Component\HttpFoundation\Request;
use Drupal\bibcite_import_orcid\Services;
use Drupal\bibcite_entity\Entity\Reference;

class OrcidImporterPageController {

  public function content($user_orcid_id) {

    $result = \Drupal::service("bibcite_import_orcid.importer")->importOrcidData($user_orcid_id);

    $markup = $this->generateMarkup($result, "", $user_orcid_id);

    return $markup;
  }

  function generateMarkup($result, $type, $user_orcid_id){

    $markup =   "<div class='container'>";
    $markup .=  "<h2>Resultado da importação para o ORCID " . $user_orcid_id . ":</h2>";
    $markup .=    "<div>";

    if(intval($result['updated'])>0){
      $markup .=      "<p> Foram actualizadas " . $result['updated'] . " referências.</p>";
    }

    if(intval($result['created'])>0){
      $markup .=    "<p> Foram criadas " . $result['created'] . " referências.</p>";
    }

    if(count($result['entities']>0)){

      $markup .= "<ul>";

      foreach($result['entities'] as $ref_id){
        $ref_entity = Reference::load($ref_id);
        $markup .= "<li><a href='/bibcite/reference/".$ref_id."'>" . $ref_entity->get('title')->getValue()[0]['value'] . "</a></li>";
      }

      $markup .= "</ul>";
    }
    $markup .=    "</div>";
    $markup .=  "</div>";

    return [
      '#markup' => $markup,
    ];
  }
}
