<?php

namespace Drupal\bibcite_import_orcid\Plugin\Block;

use Drupal\Core\Access\AccessResult;
use Drupal\Core\Block\BlockBase;
use Drupal\user\Entity\User;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Session\AccountInterface;

/**
 * Provides a block with a ORCID SYNC button.
 *
 * @Block(
 *   id = "bibcite_import_orcid_block",
 *   admin_label = @Translation("ORCID SYNC Button"),
 * )
 */
class OrcidBlock extends BlockBase
{
    /**
     * {@inheritdoc}
     */
    public function build()
    {
        $current_user_id = \Drupal::currentUser()->id();

        $parameters = \Drupal::routeMatch()->getParameters();

        $current_user = User::load($current_user_id);

        $show_block = ($current_user_id == $parameters->get('user')->id() || $current_user->hasRole('administrator')) ? true : false;

        $orcid_id =  $current_user->get('field_orcid')->getValue()[0]['value'];

        $variables = [
            "import_uid" => $current_user_id,
            "import_orcid_id" => $orcid_id,
            "show_block" => $show_block,
        ];

        $template_path = drupal_get_path("module", "bibcite_import_orcid") . "/templates/block--orcid-import.html.twig";

        $markup = \Drupal::service('twig')->loadTemplate($template_path)->render($variables);

        return [
            '#markup' => $markup,
        ];
    }
    /**
     * {@inheritdoc}
     */
    protected function blockAccess(AccountInterface $account)
    {
        return AccessResult::allowedIfHasPermission($account, 'access content');
    }
    /**
     * {@inheritdoc}
     */
    public function blockForm($form, FormStateInterface $form_state)
    {
        $config = $this->getConfiguration();

        return $form;
    }

    /**
     * {@inheritdoc}
     */
    public function blockSubmit($form, FormStateInterface $form_state)
    {
        $this->configuration['orcid_block_settings'] = $form_state->getValue('orcid_block_settings');
    }
}
