<?php

namespace Drupal\bibcite_import_orcid\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Returns responses for ORCID Import routes.
 */
class OrcidImportSuccessPageController extends ControllerBase {

  /**
   * Builds the response.
   */
  public function build() {

    $form_works = $_SESSION['imported_works'];

    foreach ($form_works as $key => $element) {
      //check if element is an array and is numeric
      if (is_array($element) && is_numeric($key)) {
        $user_works[] = $element;
      }
    }

    $total_works = count($user_works);

    $markup =  "<h2>Results of ORCID import:</h2>";
    $markup .=    "<div>";

    $markup .= "<p class='works-resume'>" . $total_works . " references imported.</p>";

    $markup .= "<table border='0' id='table-works'><tr><th>Title</th></tr>";
    foreach($user_works as $element){      
      $markup .= "<tr><td>" . $element['work']['#title'] . "</td></tr>";
    }
    $markup .= "</table>";
    $markup .= "<br><br>";
    $markup .= "<a id='btn-return-profile' href='/user'>Return to my profile</a>";
    $markup .= "<br><br>";

    $markup .=    "</div>";

    $build['content'] = [
      '#type' => 'item',
      '#markup' => $markup,
      "#prefix" => '<div class="container">',
      "#suffix" => '</div>',
      '#attached' => [
        'library' => [
          'bibcite_import_orcid/orcid-import-block',
        ],
      ],
    ];

    return $build;
  }

}
