<?php

namespace Drupal\bibcite_import_orcid\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\user\Entity\User;

/**
 * Defines bibcite_import_orcid configuration form.
 */
class ModuleConfigurationForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'bibcite_import_orcid_admin_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'bibcite_import_orcid.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('bibcite_import_orcid.settings');

    // HTML element with instructions

    $form['orcid_instructions'] = [
        "#markup" => $this->t("You can activate automatic ORCID data synchronization to occur programmatically via system cron calls every day."),
    ];

    // ORCID Client password ???

    $form['orcid_auto_import'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Use daily automatic data import/sync?'),
      '#default_value' => $config->get('orcid_auto_import'),
  ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $values = $form_state->getValues();

    $this->config('bibcite_import_orcid.settings')
        /*->set('orcid_client_id', $values['orcid_client_id'])
        ->set('orcid_client_secret', $values['orcid_client_secret'])*/
        ->set('orcid_auto_import', $values['orcid_auto_import'])
        ->save();

    // module config saved, setup the queue worker

    if ($values['orcid_auto_import'] == 1){
      $all_users = \Drupal::entityQuery('user')
                  ->condition('field_orcid', "", "<>")
                  ->execute();

      $queue = \Drupal::queue('queue_orcid');

      $queue->createQueue();

      foreach($all_users as $uid){
        $user = User::load($uid);

        $orcid_value = $user->get('field_orcid')->getValue();

        $orcid = $orcid_value[0]['value'];

        $queue->createItem($orcid);
      }
    }
  }
}
