<?php

namespace Drupal\bibcite_import_orcid\Commands;

use Drush\Commands\DrushCommands;
use Drupal\bibcite_entity\Entity\Contributor;
use Drupal\bibcite_entity\Entity\Reference;
use Drupal\user\Entity\User;

/**
 * A Drush commandfile.
 *
 * In addition to this file, you need a drush.services.yml
 * in root of your module, and a composer.json file that provides the name
 * of the services file to use.
 */
class OrcidImportCommands extends DrushCommands {


  /**
   * Deletes all entities from bibcite
   *
   * @command bibcite_import_orcid:delete_all
   * @aliases ouda
   * @usage bibcite_import_orcid:delete_all
   *
   */

  public function deleteAll() {
    

    $entity_query_ref = \Drupal::entityQuery('bibcite_reference');

    $all_references = $entity_query_ref->execute();

    echo "Deleting " . count($all_references) . "\n";

    entity_delete_multiple('bibcite_reference', $all_references);
    echo "Done.\n";

    $entity_query_contrib = \Drupal::entityQuery('bibcite_contributor');

    $all_contributors = $entity_query_contrib->execute();

    
    echo "Deleting " . count($all_contributors) . "\n";

    entity_delete_multiple('bibcite_contributor', $all_contributors);
    echo "Done.\n";

  }

}