<?php

namespace Drupal\bibcite_import_orcid\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Session\AccountInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Drupal\user\Entity\User;
use Drupal\bibcite_entity\Entity\Contributor;
use Drupal\bibcite_entity\Entity\Reference;

/**
 * Returns responses for ORCID Import routes.
 */
class OrcidImportSuccessPageController extends ControllerBase {

  /**
   * The current user.
   *
   * @var \Drupal\Core\Session\AccountInterface
   */
  protected $currentUser;

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  /**
   * The controller constructor.
   *
   * @param \Drupal\Core\Session\AccountInterface $current_user
   *   The current user.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   */
  public function __construct(AccountInterface $current_user, EntityTypeManagerInterface $entity_type_manager) {
    $this->currentUser = $current_user;
    $this->entityTypeManager = $entity_type_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('current_user'),
      $container->get('entity_type.manager')
    );
  }

  /**
   * Builds the response.
   */
  public function build() {

    $uid = \Drupal::currentUser()->id();

    $user = User::load($uid);

    array_map(function ($contributor) use (&$current_contributors_in_user) {

      $cname = $contributor->first_name[0]->value . " " . $contributor->last_name[0]->value;

      $current_contributors_in_user[$contributor->id()] = $cname;
    }, $user->field_author->referencedEntities());

    ksort($current_contributors_in_user);

    $user_contributor_ids = array_keys($current_contributors_in_user);

    $query_works = \Drupal::entityQuery('bibcite_reference')
    ->execute();

    $user_works = array();

    foreach ($query_works as $work){

      $bibcite_reference = Reference::load($work);

      $timestamp = $bibcite_reference->getCreatedTime();
      $datetimeFormat = 'Y-m-d \a\t H:i';
      $date = new \DateTime();
      $date->setTimestamp($timestamp);
      

      $contributors_ids = array_map(function ($referenced_contributor) {
          return $referenced_contributor->id();
      }, $bibcite_reference->author->referencedEntities());

      foreach ($contributors_ids as $cid){
        if (in_array($cid, $user_contributor_ids)){
          $user_works[] = $work;
        }
      }
    }

    $total_works = count($user_works);

    $markup =  "<h2>Results of ORCID import:</h2>";
    $markup .=    "<div>";

    $markup .= "<p class='works-resume'>Your profile has ". $total_works . " associated references.</p>";

    $markup .= "<table border='0' id='table-works'><tr><th>Title</th><th>Created Date</th></tr>";
    foreach($user_works as $ref_id){
      
      $ref_entity = Reference::load($ref_id);
      
      $markup .= "<tr><td><a href='/bibcite/reference/".$ref_id."'>" . $ref_entity->get('title')->getValue()[0]['value'] . "</a></td><td class='table-date'>". $date->format($datetimeFormat)."</td></tr>";
    }
    $markup .= "</table>";
    $markup .= "<br><br>";
    $markup .= "<a id='btn-return-profile' href='/user'>Return to my profile</a>";
    $markup .= "<br><br>";

    $markup .=    "</div>";

    $build['content'] = [
      '#type' => 'item',
      '#markup' => $markup,
      "#prefix" => '<div class="container">',
      "#suffix" => '</div>',
      '#attached' => [
        'library' => [
          'bibcite_import_orcid/orcid-import-block',
        ],
      ],
    ];

    return $build;
  }

}
