(function ($, Drupal) {
  Drupal.behaviors.bibleDropdown = {
    attach: function (context, settings) {
      $('#book-select').on('change', function() {
        // Get the current Bible shortname from the URL or use default
        var pathParts = window.location.pathname.split('/');
        var bibleShortname = pathParts[2] || 'KJV'; // Default to KJV if not found
        window.location.href = '/bible/' + bibleShortname + '/' + this.value + '/1';
      });

      $('#version-select').on('change', function() {
        // Get the current book and chapter from the URL
        var pathParts = window.location.pathname.split('/');
        var bookCode = pathParts[3] || 'GEN'; // Default to GEN if not found
        var chapter = pathParts[4] || '1'; // Default to 1 if not found
        window.location.href = '/bible/' + this.value + '/' + bookCode + '/' + chapter;
      });
    }
  };
})(jQuery, Drupal);
