<?php

namespace Drupal\bible;

use Drupal\Core\Entity\ContentEntityTypeInterface;
use Drupal\Core\Entity\Sql\SqlContentEntityStorageSchema;

/**
 * Defines the Bible verse schema handler.
 *
 * This class adds custom indexes and unique constraints to the bible_verse
 * table for improved performance and data integrity.
 */
class BibleVerseStorageSchema extends SqlContentEntityStorageSchema {

  /**
   * {@inheritdoc}
   */
  protected function getEntitySchema(ContentEntityTypeInterface $entity_type, $reset = FALSE) {
    $schema = parent::getEntitySchema($entity_type, $reset);

    // Get the base table name.
    $base_table = $entity_type->getBaseTable();

    if (isset($schema[$base_table])) {
      // Add unique constraint on bible, book, chapter, verse.
      // This ensures data integrity - no duplicate verses can exist.
      $schema[$base_table]['unique keys']['bible_verse_unique'] = [
        'bible',
        'book',
        'chapter',
        'verse',
      ];

      // Add performance index for common queries.
      // Most queries filter by bible, book, and chapter.
      $schema[$base_table]['indexes']['bible_verse_lookup'] = [
        'bible',
        'book',
        'chapter',
      ];
    }

    return $schema;
  }

}
