<?php

namespace Drupal\Tests\bible\Unit\Entity;

use Drupal\bible\Entity\Bible;
use Drupal\bible\BibleInterface;
use Drupal\Tests\UnitTestCase;

/**
 * Basic tests for the Bible entity class.
 *
 * @coversDefaultClass \Drupal\bible\Entity\Bible
 * @group bible
 */
class BibleEntityTest extends UnitTestCase {

  /**
   * Tests Bible entity class exists and extends the correct base class.
   */
  public function testBibleEntityClass() {
    $this->assertTrue(class_exists(Bible::class), 'Bible entity class should exist');
    $this->assertTrue(is_subclass_of(Bible::class, 'Drupal\Core\Entity\ContentEntityBase'), 'Bible should extend ContentEntityBase');
  }

  /**
   * Tests Bible entity implements the BibleInterface.
   */
  public function testBibleEntityInterface() {
    $this->assertTrue(class_exists(Bible::class), 'Bible entity class should exist');
    $this->assertTrue(in_array(BibleInterface::class, class_implements(Bible::class)), 'Bible should implement BibleInterface');
  }

  /**
   * Tests that essential methods exist on the Bible entity.
   */
  public function testBibleEntityMethods() {
    $reflection = new \ReflectionClass(Bible::class);

    // Test that key methods exist.
    $this->assertTrue($reflection->hasMethod('baseFieldDefinitions'), 'Bible should have baseFieldDefinitions method');
    $this->assertTrue($reflection->getMethod('baseFieldDefinitions')->isStatic(), 'baseFieldDefinitions should be static');
    $this->assertTrue($reflection->getMethod('baseFieldDefinitions')->isPublic(), 'baseFieldDefinitions should be public');
  }

  /**
   * Tests Bible entity namespace and class naming.
   */
  public function testBibleEntityNamespace() {
    $reflection = new \ReflectionClass(Bible::class);

    $this->assertEquals('Drupal\bible\Entity', $reflection->getNamespaceName(), 'Bible should be in correct namespace');
    $this->assertEquals('Bible', $reflection->getShortName(), 'Bible should have correct class name');
  }

  /**
   * Tests Bible entity has the expected annotation.
   */
  public function testBibleEntityAnnotation() {
    $reflection = new \ReflectionClass(Bible::class);
    $doc_comment = $reflection->getDocComment();

    // Check for ContentEntityType annotation.
    $this->assertStringContainsString('@ContentEntityType', $doc_comment, 'Bible should have ContentEntityType annotation');
    $this->assertStringContainsString('id = "bible"', $doc_comment, 'Bible should have correct entity ID');
  }

  /**
   * Tests that BibleInterface exists.
   */
  public function testBibleInterface() {
    $this->assertTrue(interface_exists(BibleInterface::class), 'BibleInterface should exist');
  }

}
