<?php

declare(strict_types=1);

namespace Drupal\Tests\user\Unit\Plugin\migrate\process;

use Drupal\Tests\migrate\Unit\process\MigrateProcessTestCase;
use Drupal\user\Plugin\migrate\process\ConvertTokens;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\IgnoreDeprecations;

/**
 * Tests the ConvertTokens plugin.
 */
#[Group('user')]
#[IgnoreDeprecations]
class ConvertTokensTest extends MigrateProcessTestCase {

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->plugin = new ConvertTokens([], 'convert_tokens', []);
  }

  /**
   * Tests conversion of user tokens.
   */
  public function testConvertTokens(): void {
    $value = $this->plugin->transform('Account details for !username at !site', $this->migrateExecutable, $this->row, 'destination_property');
    $this->assertEquals('Account details for [user:name] at [site:name]', $value);
  }

  /**
   * Tests conversion of user tokens with a NULL value.
   */
  public function testConvertTokensNull(): void {
    $value = $this->plugin->transform(NULL, $this->migrateExecutable, $this->row, 'destination_property');
    $this->assertEquals('', $value);
  }

}
