<?php

declare(strict_types=1);

namespace Drupal\Tests\layout_builder\Kernel;

use Drupal\Core\Routing\RouteObjectInterface;
use Drupal\entity_test\Entity\EntityTest;
use Drupal\entity_test\EntityTestHelper;
use Drupal\KernelTests\KernelTestBase;
use Drupal\layout_builder\Entity\LayoutBuilderEntityViewDisplay;
use Drupal\layout_builder\Hook\LayoutBuilderHooks;
use PHPUnit\Framework\Attributes\CoversMethod;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Session\Session;
use Symfony\Component\HttpFoundation\Session\Storage\MockArraySessionStorage;
use Symfony\Component\Routing\Route;

/**
 * Tests Entity View Alter.
 */
#[Group('layout_builder')]
#[CoversMethod(LayoutBuilderHooks::class, 'entityViewAlter')]
#[RunTestsInSeparateProcesses]
class EntityViewAlterTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = [
    'layout_discovery',
    'layout_builder',
    'layout_builder_defaults_test',
    'entity_test',
    'user',
  ];

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    EntityTestHelper::createBundle('bundle_with_extra_fields');
    $this->installEntitySchema('entity_test');
    $this->installConfig(['layout_builder_defaults_test']);
  }

  /**
   * Tests that contextual links are removed when rendering Layout Builder.
   */
  public function testContextualLinksRemoved(): void {
    $display = LayoutBuilderEntityViewDisplay::load('entity_test.bundle_with_extra_fields.default');
    $entity = EntityTest::create();
    $build = [
      '#contextual_links' => ['entity.node.canonical'],
    ];
    // Create a fake request that starts with layout_builder.
    $request = Request::create('<front>');
    $request->attributes->set(RouteObjectInterface::ROUTE_NAME, 'layout_builder.test');
    $request->attributes->set(RouteObjectInterface::ROUTE_OBJECT, new Route('/'));
    $request->setSession(new Session(new MockArraySessionStorage()));
    \Drupal::requestStack()->push($request);
    // Assert the contextual links are removed.
    $layoutBuilderEntityViewAlter = new LayoutBuilderHooks();
    $layoutBuilderEntityViewAlter->entityViewAlter($build, $entity, $display);
    $this->assertArrayNotHasKey('#contextual_links', $build);
  }

}
