<?php

declare(strict_types=1);

namespace Drupal\Tests\system\Functional;

use Drupal\Tests\BrowserTestBase;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests module and theme pages do not have XSS vulnerabilities.
 */
#[Group('system')]
#[RunTestsInSeparateProcesses]
class ModuleThemePageXssVulnerabilityTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['system'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $admin = $this->drupalCreateUser([
      'administer modules',
      'administer themes',
    ]);
    $this->drupalLogin($admin);
  }

  /**
   * Tests extension info cannot create XSS vulnerabilities.
   */
  public function testExtensionInfoXss(): void {
    $this->drupalGet("admin/modules");
    $this->assertSession()->pageTextContains("alert('Evil module name');");
    $this->assertSession()->pageTextContains("alert('Evil module desc');");
    $this->assertSession()->responseNotContains("<script>alert(");
    $this->drupalGet("admin/appearance");
    $this->assertSession()->pageTextContains("alert('Evil theme name');");
    $this->assertSession()->pageTextContains("alert('Evil theme desc');");
    $this->assertSession()->responseNotContains("<script>alert(");
  }

}
