<?php

declare(strict_types=1);

namespace Drupal\KernelTests\Core\Batch;

use Drupal\KernelTests\KernelTestBase;
use PHPUnit\Framework\Attributes\Group;
use PHPUnit\Framework\Attributes\RunTestsInSeparateProcesses;

/**
 * Tests batch functionality.
 */
#[Group('Batch')]
#[RunTestsInSeparateProcesses]
class BatchKernelTest extends KernelTestBase {

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    require_once $this->root . '/core/includes/batch.inc';
  }

  /**
   * Tests _batch_needs_update().
   */
  public function testNeedsUpdate(): void {
    // Before ever being called, the return value should be FALSE.
    $this->assertEquals(FALSE, _batch_needs_update());

    // Set the value to TRUE.
    $this->assertEquals(TRUE, _batch_needs_update(TRUE));
    // Check that without a parameter TRUE is returned.
    $this->assertEquals(TRUE, _batch_needs_update());

    // Set the value to FALSE.
    $this->assertEquals(FALSE, _batch_needs_update(FALSE));
    $this->assertEquals(FALSE, _batch_needs_update());
  }

}
