<?php

namespace Drupal\Core\Ajax;

use Drupal\Core\Asset\AttachedAssets;

/**
 * AJAX command for conveying changed tabledrag rows.
 *
 * This command is provided an id of a table row then does the following:
 * - Marks the row as changed.
 * - If a message generated by the tableDragChangedWarning is not present above
 *   the table the row belongs to, that message is added there.
 *
 * @see Drupal.AjaxCommands.prototype.tabledragChanged
 *
 * @ingroup ajax
 */
class TabledragWarningCommand implements CommandInterface, CommandWithAttachedAssetsInterface {

  /**
   * Constructs a TableDragWarningCommand object.
   *
   * @param string $id
   *   The id of the changed row.
   * @param string $tabledrag_instance
   *   The identifier of the tabledrag instance.
   */
  public function __construct(
    protected string $id,
    protected string $tabledrag_instance,
  ) {}

  /**
   * {@inheritdoc}
   */
  public function render() {
    return [
      'command' => 'tabledragChanged',
      'id' => $this->id,
      'tabledrag_instance' => $this->tabledrag_instance,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getAttachedAssets() {
    $assets = new AttachedAssets();
    $assets->setLibraries(['core/drupal.tabledrag.ajax']);
    return $assets;
  }

}
