const ed11yLang={en:{toggleAccessibilityTools:"Toggle accessibility tools",toggleDisabled:"No content available for Editoria11y to check.",panelCount0:"No issues detected.",panelCountAllDismissed:"All issues hidden.",panelCount1:"One issue detected.",panelCountMultiple:" issues detected.",panelCountBase:"<span class='count'>No</span> <span class='content-type'>issues detected</span>.",panelControls:"Editorially",buttonToolsContent:"Check headings & alt text",buttonToolsActive:"Hide headings & alt text",buttonOutlineContent:"Headings",buttonAltsContent:"Alt Text",buttonFirstContent:"Go to first alert",buttonNextContent:"Go to next alert",buttonPrevContent:"Go to previous alert",buttonShowHiddenAlert:"Show hidden alert",buttonHideHiddenAlert:"Hide hidden alert",buttonShowHiddenAlerts:e=>`Show ${e} hidden alerts`,buttonHideHiddenAlerts:e=>`Hide ${e} hidden alerts`,buttonShowAlerts:"Show accessibility alerts",buttonShowNoAlert:"Show accessibility checker",buttonHideChecker:"Hide accessibility checker",buttonHideAlerts:"Hide accessibility alerts",panelCheckOutline:'<p class="ed11y-small">This shows the <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/" target="_blank" title="Opens in new tab">heading outline</a>. Check that it matches how the content is organized visually.</p>',panelCheckAltText:'<p class="ed11y-small">Check that each image <a href="https://www.w3.org/WAI/tutorials/images/informative/" target="_blank" title="Opens in new tab">describes what it means in context</a>, and that there are no images of text.</p>',noImagesFound:"No images found.",altLabelPrefix:"Alt text: ",errorAltMissing:"(missing!)",errorAltNull:"(none; image marked as decorative)",errorOutlinePrefixSkippedLevel:"(flagged for skipped level) ",errorOutlinePrefixHeadingEmpty:"(empty heading) ",errorOutlinePrefixHeadingIsLong:"(flagged for length) ",consoleNotSupported:"This browser can not run Editoria11y.",jumpedToInvisibleTip:"Note: this content may not be visible. Look for it inside the outlined container.",jumpedToAriaHiddenTip:"The item with this issue may be invisible or off screen.",suspiciousWords:["image of","graphic of","picture of","photo of","photograph of","placeholder","spacer","tbd","todo","copyright","courtesy of","photo by"],meaninglessAlt:["alt","chart","decorative","image","graphic","photo","placeholder","placeholder image","spacer","tbd","todo","to do"],badEndingForAlt:["photo","image","photograph","picture"],linksUrls:["http:/","https:/",".asp",".htm",".php",".edu/",".com/"],linksMeaningless:/(learn|to|more|now|this|page|link|site|website|check|out|view|our|read|download|form|here|click|"|'|\?|\.|-|,|:|>|<|\s)+/g,linkStringsNewWindows:/window|\stab|download/g,toggleManualCheck:"manual check needed",toggleAlert:"alert",issue:"Issue",toggleAriaLabel:e=>`Accessibility ${e}`,transferFocus:"Edit this content",dismissOkButtonContent:"Mark as OK",dismissHideButtonContent:"Mark as ignored",dismissActions:e=>`${e} similar issues`,dismissHideAllButton:"Ignore all like this",dismissOkAllButton:"Mark all like this as OK",dismissOkTitle:"Hides this alert for all editors",dismissHideTitle:"Hides this alert for you",undismissOKButton:"Restore this alert marked as OK",undismissHideButton:"Restore this hidden alert",undismissNotePermissions:"This alert has been hidden by an administrator",reportsLink:"Open site reports in new tab",closeTip:"Close",panelHelpTitle:"About this tool",panelHelp:`
    <p><a href="https://editoria11y.princeton.edu/">Editoria11y</a> checks for common accessibility needs, such as image alternative text, meaningful heading outlines and well-named links.</p>
    <p>Many alerts are "manual checks." Manual checks can be dismissed:</p>
    <ul>
        <li>"Mark as checked and OK" hides the alert for all editors.</li>
        <li>"Ignore this manual check" leaves the tip visible to other editors.</li>
    </ul>
    <p>Dismissed alerts can be found via the "Show hidden alerts" toggle.</p>
    <p>If an incorrect alert is appearing on many pages, site administrators can tell the checker to ignore particular elements and page regions.</p>
    <p>And remember that automated checkers cannot replace <a href='https://webaim.org/resources/evalquickref/'> proofreading and testing for accessibility</a>.</p>
    <p><br><a href='https://github.com/itmaybejj/editoria11y/issues' class='ed11y-small'>Report bugs & request changes <span aria-hidden="true">&raquo;</span></a></p>
    `,headingExample:`
        <ul>
            <li>Heading level 1
                <ul>
                    <li>Heading level 2: a topic
                        <ul><li>Heading level 3: a subtopic</li></ul></li>
                    <li>Heading level 2: a new topic</li>
                </ul>
            </li>
        </ul>`,headingLevelSkipped:{title:"Manual check: was a heading level skipped?",tip:(e,t)=>`<p>Headings and subheadings create a <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/" target="_blank" title="Opens in new tab">navigable table of contents</a> for assistive devices. The numbers indicate indents in a nesting relationship:</p>
            ${Ed11y.M.headingExample}
            <p>This heading skipped from level ${e} to level ${t}. From a screen reader, this sounds like content is missing.</p>
            <p><strong>To fix:</strong> adjust levels to form an accurate outline, without gaps.</p>
            `},headingEmpty:{title:"Heading tag without any text",tip:()=>`<p>Headings and subheadings create a <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/" target="_blank" title="Opens in new tab">navigable table of contents</a> for assistive devices. The numbers indicate indents in a nesting relationship:</p>
            ${Ed11y.M.headingExample}
            <p>Empty headings create confusing gaps in this outline: they could mean the following content is still part of the previous section, or that the text was unpronounceable for some reason.</p>
            <p><strong>To fix:</strong> add text to this heading, or delete this empty line.</p>
            `},headingIsLong:{title:"Manual check: long heading",tip:()=>`<p>Headings should be brief and clear. Assistive devices use them as a <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/" target="_blank" title="Opens in new tab">navigable table of contents</a> for the page. The numbers indicate indents in a nesting relationship:</p>  
            ${Ed11y.M.headingExample}
            <p><strong>To fix:</strong> shorten this heading if possible, or remove the heading style if it was only applied to this text to provide visual emphasis.</p>
            `},blockquoteIsShort:{title:"Manual check: is this a blockquote?",tip:()=>'<p>Blockquote formatting tells screen readers that the text should be announced as a quotation. This was flagged because short blockquotes are <em>sometimes</em> actually <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/" target="_blank" title="Opens in new tab">headings</a>. If this is a heading and not a quotation, use heading formatting instead, so this appears in the page outline.</p>'},altAttributeExample:`<p>Note that a <a href="https://www.w3.org/WAI/tutorials/images/informative" target="_blank" title="Opens in new tab">good alt describes the image's message</a>, not simply what it contains. Depending on the context, the alt for the picture of a child kicking a ball might emphasize the setting, the child, the kick or the ball:</p>
            <ul>
                <li>The sunny spring day brought kids to the park for some soccer.</li>
                <li>A.J. wearing the new team uniform.</li>
                <li>The game-winning kick curved in from the left sideline!</li>
                <li>The size 4 ball is the right size for this 9-year-old child.</li>
            </ul>`,altMissing:{title:"Image has no alternative text attribute",tip:()=>`<p>When screen readers encounter an image with no alt attribute at all, they dictate the url of the image file instead, often one letter at a time.</p>
            <p><strong>To fix:</strong> either add an empty alt (alt="") to indicate this image should be ignored by screen readers, or add descriptive alt text.</p>
            ${Ed11y.M.altAttributeExample}`},altNull:{title:"Manual check: image has no alt text",tip:()=>`<p>Unless this image is purely decorative (a spacer icon or background texture), an alt should probably be provided. Photos in page content <strong>almost always need alt text.</strong> Since many screen reader users can see there is an image present, it can be very confusing to move the cursor across the place on the page where an image is visible, but hear nothing.</p>
        ${Ed11y.M.altAttributeExample}`},altURL:{title:"Image's text alternative is a URL",tip:e=>`This image's alt text is "${e}," which probably describes the file name, not the contents of the image.
        <p><strong>To fix:</strong> set this image's alternative text to a concise description of what this image means in this context.</p>
        ${Ed11y.M.altAttributeExample}`},altMeaningless:{title:"Alt text is meaningless",tip:e=>`<p>This image's alt text is "${e}," which was flagged for being common placeholder text.</p>
        <p><strong>To fix:</strong> set this image's alternative text to a concise description of what this image means in this context.</p>
        ${Ed11y.M.altAttributeExample}`},altMeaninglessLinked:{title:"Linked alt text is meaningless",tip:e=>`<p>When a link includes an image, <a href="https://webaim.org/techniques/hypertext/link_text#alt_link" target="_blank" title="opens in new tab">the image's alt text becomes the link text</a> announced by screen readers.
            Links should clearly and concisely describe their destination, even out of context.</p>
           <p>This image's alt text is "${e}," which probably does not describe this link.</p>`},altURLLinked:{title:"Linked image's text alternative is a URL",tip:e=>`<p>This image's alt text is "${e}," which is probably a filename.</p>
        <p>When a link is wrapped around an image and there is no other text, the <a href="https://webaim.org/techniques/hypertext/link_text#alt_link" target="_blank" title="Opens in new tab">image's alt text becomes the link text</a> announced by screen readers.
            Links should clearly and concisely describe their destination; a URL (usually pronounced by the screen reader one letter at a time) does not.</p>
            <ul>
                <li>Good link text: "About us"</li>
                <li>Bad link text: "H T T P S colon forward slash forward slash example dot com forward slash aye bee oh you tee you ess</li>
            </ul>`},altImageOf:{title:"Manual check: possibly redundant text in alt",tip:e=>`<p>This image's alt text is "${e}," which mentions that this image is an image.</p>
        <p>Screen readers announce they are describing an image when reading alt text, so 
            phrases like "image of" and "photo of" are usually redundant in alt text; the screen reader user hears "image: image of something."</p>
            <p>Note that this is OK if the format is referring to the <strong>content</strong> of the image:</p>
            <ul><li>Format is redundant: "<em>photo of</em> a VHS tape"</li>
            <li>Format is relevant: "<em>photo of</em> a VHS tape in a photo album being discussed in a history class"</li></ul>`},altImageOfLinked:{title:"Manual check: possibly redundant text in linked image",tip:e=>`<p>This image's alt text is "${e}," which mentions that this image is an image.</p>
        <hr><p>Links should clearly and concisely describe their destination. Since words like "image," "graphic" or "photo" are already redundant in text alternatives (screen readers already identify the image as an image), their presence in a linked image usually means the image's text alternative is <a href="https://webaim.org/techniques/hypertext/link_text#alt_link" title="Opens in new tab" target="_blank">describing the image instead of the link</a>.</p>
            <ul>
                <li>Good link text: "About us"</li>
                <li>Bad link text: "Image of five people jumping"</li>
            </ul>`},altDeadspace:{title:"Image's text alternative is unpronounceable",tip:e=>`<p>This image's alt text is "${e}," which only contains unpronounceable symbols and/or spaces. Screen readers will announce that an image is present, and then pause awkwardly: "image: ____."</p>
        <p><strong>To fix:</strong> add a descriptive alt, or provide a <em>completely</em> empty alt (alt="") if this is just an icon or spacer, and screen readers should ignore it.</p>
            ${Ed11y.M.altAttributeExample}`},altEmptyLinked:{title:"Linked Image has no alt text",tip:()=>`<p>When a link is wrapped around an image, the image's alt text <a href="https://webaim.org/techniques/hypertext/link_text#alt_link" title="Opens in new tab" target="_blank">provides the link's title for screen readers</a>.</p>
        <p><strong>To fix:</strong> set this image's alternative text to something that describes the link's destination, or add text next to the image, within the link.</p>`},altLong:{title:"Manual check: very long alternative text",tip:e=>`<p>Image text alternatives are announced by screen readers as a single run-on sentence; listeners must listen to the entire alt a second time if they miss something. If this cannot be reworded to something succinct, it is better to use the alt to reference a <em>visible</em> <a href="https://www.w3.org/WAI/tutorials/images/complex/" title="Opens in new tab" target="_blank">text alternative for complex images</a>. For example:</p>
            <ul><li>"Event poster; details follow in caption"</li>
            <li>"Chart showing our issues going to zero; details follow in table"</li></ul>
            This image's alt text is: <em>${e}</em>
            `},altLongLinked:{title:"Manual check: very long alternative text in linked image",tip:e=>`<p><a href="https://webaim.org/techniques/hypertext/link_text#alt_link" title="Opens in new tab" target="_blank">The alt text on a linked image is used to describe the link destination</a>. Links should be brief, clear and concise, as screen reader users often listen to the list of links on the page to find content of interest. Long alternative text inside a link often indicates that the image's text alternative is describing the image instead rather than the link.</p>
        This image's alt text is: <em>${e}</em>`},altPartOfLinkWithText:{title:"Manual check: link contains both text and an image",tip:e=>`<p>Screen readers will <a href="https://www.w3.org/WAI/tutorials/images/functional/" title="Opens in new tab" target="_blank">include the image's alt text when describing this link</a>.</p>
            <p>Check that the combined text is concise and meaningful:<br>"<em><strong>${e}</strong></em>"</p>
            <p></p>
            <ul>
                <li>Keep alts that add relevant meaning:<br>"Buy (A Tigers v. Falcons ticket)."</li>
                <li>Edit unhelpful or irrelevant alts:<br>"Buy (A piece of paper with team logos on it)."</li>
                <li>Remove unnecessary alts:<br>"Buy Tigers v. Falcons tickets (A Tigers v. Falcons ticket)."</li>
            </ul>
        `},linkNoTextExample:'<p>Screen readers will either say nothing when they reach this link: <br><em>"Link, [...awkward pause where the link title should be...],"</em><br>or read the URL: <br><em>"Link, H-T-T-P-S forward-slash forward-slash example dot com"</em></p>',linkTextIgnored:e=>`
    <p>Screen readers will only read the text of the link type indicator on this link:<br>
    <em>"<strong>${e}</strong>"</em></p>
    `,linkNoText:{title:"Link with no accessible text",tip:e=>`<p>This link is either a typo (a linked space character), or a linked image with no text alternative.</p>
        ${e?Ed11y.M.linkTextIgnored(e):Ed11y.M.linkNoTextExample}
        <p><strong>To fix:</strong></p>
        <ul><li>If this a typo, delete it. Note that typo links can be hard to see if they are next to a "real" link: one will be on the text, one on a space.</li><li>If it is a real link, add text to describe where it goes.</li>`},linkTextIsURL:{title:"Manual check: is this link text a URL?",tip:e=>`<p>This link's text is:<br> <strong>${e}</strong></p>
        <p><a href="https://webaim.org/techniques/hypertext/link_text" title="Opens in new tab" target="_blank">Links should be meaningful and concise</a>. Readers often skim by link titles. This is especially true of screen reader users, who navigate using a list of on-page links.</p>
         <p>A linked URL breaks this pattern; the reader has to read the preceding paragraph to figure out the link's purpose from context.</p>
            <ul>
                <li>Meaningful and concise link: "Tips for writing meaningful links"</li>
                <li>Linked URL, as pronounced by a screen reader: "H T T P S colon forward-slash forward-slash example dot com forward-slash tips forward-slash meaningful-links"</li>
            </ul>`},linkTextIsGeneric:{title:"Manual check: is this link meaningful and concise?",tip:e=>`<p>This link's text is: <strong>${e}</strong></p>
        <p>Readers skim for links. This is especially true of screen reader users, who navigate using a list of on-page links.</p>
                <p>Generic links like "click here," "read more" or "download" expect the reader be reading slowly and carefully enough to figure out each link's purpose from context. Few readers do this, so click-through rates on meaningless links are extremely poor.</p>
                <ul>
                <li>Ideal: "Learn about <a href="https://webaim.org/techniques/hypertext/link_text" title="Opens in new tab" target="_blank">meaningful links"</a></strong></li>
                <li>Not meaningful: "Click <a href="https://webaim.org/techniques/hypertext/link_text" title="Opens in new tab" target="_blank">here</a> to learn about meaningful links."</li>
                <li>Not concise: "<a href="https://webaim.org/techniques/hypertext/link_text" title="Opens in new tab" target="_blank">Click here to learn more about meaningful links</a>"</li>
                </ul>
                `},linkDocument:{title:"Manual check: is the linked document accessible?",tip:()=>`<p>Many mobile and assistive device users struggle to read content in PDFs. PDFs generally do not allow for changing font sizes, and often contain features that are incompatible with screen readers.</p>
        <p>Ideally make the content of this linked PDF available on a Web page or in an editable document, and only link to this PDF as a "printable" alternative. If this PDF is the only way you are providing to access this content, you will need to <a href='https://webaim.org/techniques/acrobat/' target='_blank' title="Opens in new tab">manually check that the PDF is well-structured</a>, with headings, lists and table headers, and provides alt text for its images.</p>`},linkNewWindow:{title:"Manual check: is opening a new window expected?",tip:()=>`<p>Readers can always choose to open a link a new window. When a link forces open a new window, it can be confusing and annoying, especially for assistive device users who may wonder why their browser's "back" button is suddenly disabled.</p>
                <p>There are two general exceptions:</p>
                <ul>
                    <li>When the user is filling out a form, and opening a link in the same window would cause them to lose their work.</li>
                    <li>When the user is clearly warned a link will open a new window.</li>
                </ul>
                <p><strong>To fix:</strong> set this link back its default target, or add a screen-reader accessible warning (text or an icon with alt text).</p>
                `},tableNoHeaderCells:{title:"Table has no header cells",tip:()=>`
                <p>To fix:</p>
                <ul><li>If this table contains data that is meaningfully organized by row and column, edit the table's properties and specify whether headers have been placed in the first row, column or both. This lets screen reader users hear the headers repeated while navigating the content.</li>
                <li>If this table does not contain rows and columns of data, but is instead being used for visual layout, remove it. Tables overflow the page rather than reflowing on mobile devices, and should only be used when the horizontal relationships are necessary to understand the content.</li></ul>
            `},tableContainsContentHeading:{title:"Content heading inside a table",tip:()=>`<p>To fix: remove heading formatting. Use row and column headers instead.</p>
        <p>Content headings ("Heading 1", "Heading 2") form a navigable table of contents for screen reader users,  
        labelling all content <strong>until the next heading</strong>. Table headers label specific columns or rows within a table.</p> 
            <p></p>
            <table><tr><th>1</th><th>2</th><th>3</th><td rowspan="2">To illustrate: a <strong>table</strong> header in cell 2 would only label its column: cell B. <br><br>
            A <strong>content</strong> heading in cell 2 would label all subsequent text, reading from left to right: cells 3, A, B and C, as well as this text!</td></tr>
            <tr><td>A</td><td>B</td><td>C</td></table>
            `},tableEmptyHeaderCell:{title:"Empty table header cell",tip:()=>`
                <p>When exploring tables, screen readers repeat table header cells as needed to orient users. 
                Without headers, it is very easy to get lost; screen reader users have to count columns and rows and try to remember which columns went with which rows.</p>
                <p><strong>To fix:</strong> make sure each header cell in this table contains text.</p>
            `},textPossibleList:{title:"Manual check: should this have list formatting?",tip:e=>`<p>List formatting is structural:</p> 
            <ol><li>List formatting indents and reflows on overflow. Text aligns vertically with the line above it.</li>
            <li>Lists are machine-readable. Screen readers can orient their users, announcing this as "list item, 2 of 3."</li></ol>
            <p>&nbsp;&nbsp;&nbsp;&nbsp;3. But this third item is just a sentence with a number in front of it. It wraps incorrectly, and screen readers do not know it is related to the other items in the list.</p>
            <p><strong>To fix:</strong> if this "${e}" is part of a list, replace it with list formatting.</p>
            `},textPossibleHeading:{title:"Manual check: should this be a heading?",tip:()=>`<p>If this all-bold line of text is functioning as a heading for the following text rather than a visual emphasis, replace the bold formatting with the appropriately numbered heading. Otherwise, dismiss this alert.</p>
        <p>Headings and subheadings create a <a href="https://www.w3.org/WAI/tutorials/page-structure/headings/" title="Opens in new tab" target="_blank">navigable table of contents</a> for assistive devices. The heading's <strong><em>number</em></strong> indicates its <strong><em>depth</em></strong> in the page outline; e.g.:</p>
            ${Ed11y.M.headingExample}
            
            `},textUppercase:{title:"Manual check: is this uppercase text needed?",tip:()=>`<p>UPPERCASE TEXT CAN BE MORE DIFFICULT TO READ FOR MANY PEOPLE, AND IS OFTEN INTERPRETED AS SHOUTING.</p>
         <p>Consider using sentence case instead, and using bold text or font changes for visual emphasis, or structural formatting like headings for emphasis that will also be announced by screen readers.</p>`},embedVideo:{title:"Manual check: is this video accurately captioned?",tip:()=>`<p>If a recorded video contains speech or meaningful sounds, it must <a href="https://www.w3.org/WAI/media/av/captions/" title="Opens in new window" target="_blank">provide captions</a>.</p>
            <p>Note that automatic, machine-generated captions must be proofread, and speaker identifications must be added, before being considered an equal alternative.</p>`},embedAudio:{title:"Manual check: is an accurate transcript provided?",tip:()=>`<p>If this audio contains speech, a <a href="https://www.w3.org/WAI/media/av/transcribing/" target="_blank" title="Opens in new window">text alternative</a> must be provided on this page or linked.</p>
            <p>Note that automatic, machine-generated transcripts must be proofread, and speaker identifications must be added, before being considered an equal alternative</p>`},embedVisualization:{title:"Manual check: is this visualization accessible?",tip:()=>`<p>Visualization widgets are often difficult or impossible for assistive devices to operate, and can be difficult to understand for readers with low vision or colorblindness.</p>
            <p>Unless this particular widget has high visual contrast, can be operated by a keyboard and described by a screen reader, assume that an alternate format (text description, data table or downloadable spreadsheet) should also be provided.</p>`},embedTwitter:{title:"Manual check: is this embed a keyboard trap?",tip:()=>`<p>If embedded feeds are set to show a high number of items, keyboard users may have to click the tab key dozens or hundreds of times to exit the component.</p>
            <p>Check to make sure only a small number of items auto-load immediately or while scrolling. Having additional items load on request ("show more") is fine.</p>`},embedCustom:{title:"Manual check: is this embedded content accessible?",tip:()=>"<p>Please make sure images inside this embed have alt text, videos have captions, and interactive components can be <a href='https://webaim.org/techniques/keyboard/'>operated by a keyboard</a>.</p>"}}};class Ed11yTestEmbeds{check(){let e=Ed11y.srcMatchesOptions(Ed11y.elements.iframe,Ed11y.options.videoContent);e=e?e.concat(Array.from(Ed11y.elements.video)):Ed11y.elements.video;if(e.length>0){e.forEach(e=>{let t=Ed11y.dismissalKey(e?.getAttribute("src")!=="undefined"?e.getAttribute("src"):e.querySelector("[src]")?.getAttribute("src"));Ed11y.results.push({element:e,test:"embedVideo",content:Ed11y.M.embedVideo.tip(),position:"beforebegin",dismissalKey:t})})}let t=Ed11y.srcMatchesOptions(Ed11y.elements.iframe,Ed11y.options.audioContent);t=t?t.concat(Array.from(Ed11y.elements.audio)):Ed11y.elements.audio;if(t.length>0){t.forEach(e=>{let t=Ed11y.dismissalKey(e?.getAttribute("src")!=="undefined"?e.getAttribute("src"):e.querySelector("[src]")?.getAttribute("src"));Ed11y.results.push({element:e,test:"embedAudio",content:Ed11y.M.embedAudio.tip(),position:"beforebegin",dismissalKey:t})})}let s=Ed11y.srcMatchesOptions(Ed11y.elements.iframe,Ed11y.options.dataVizContent);if(s.length>0){s.forEach(e=>{let t=Ed11y.dismissalKey(e.getAttribute("src"));Ed11y.results.push({element:e,test:"embedVisualization",content:Ed11y.M.embedVisualization.tip(),position:"beforebegin",dismissalKey:t})})}let i=Ed11y.srcMatchesOptions(Ed11y.elements.frame,Ed11y.options.twitterContent);if(i.length>0){i.forEach(t=>{let e=t.querySelectorAll(".timeline-TweetList-tweet");if(!!e&&e>3){let e=Ed11y.dismissalKey(t.getAttribute("src"));Ed11y.results.push({element:t,test:"embedTwitter",content:Ed11y.M.embedTwitter.tip(),position:"beforebegin",dismissalKey:e})}})}if(Ed11y.options.embeddedContent){Ed11y.elements.embed?.forEach(e=>{let t=Ed11y.dismissalKey(e.getAttribute("src")+e.getAttribute("id")+e.getAttribute("class"));Ed11y.results.push({element:e,test:"embedCustom",content:Ed11y.M.embedCustom.tip(),position:"beforebegin",dismissalKey:t})})}}}class Ed11yTestHeadings{check(){Ed11y.panel?.querySelectorAll("#ed11y-outline-list li, .ed11y-headings-label")?.forEach(e=>e.remove());let d=0;let r=false;Ed11y.headingOutline=[];let c="afterbegin";Ed11y.elements.allH?.filter(e=>Ed11y.elementNotHidden(e))?.forEach(e=>{if(!Ed11y.addedNodeReadyToCheck(e)){return}let t;let s=[];if(e.isContentEditable!==r){let t=e.closest("[contenteditable]");if(t){Ed11y.options.editorHeadingLevel.some(e=>{if(t.closest(e.selector)){if(e.previousHeading==="inherit"){return true}d=e.previousHeading;return true}})}r=e.isContentEditable}if(e.hasAttribute("aria-level")){t=+e.getAttribute("aria-level")}else{t=+e.tagName.slice(1)}t=parseInt(t);let i="";let n="";let o=Ed11y.computeText(e);let l=o.length;let a=false;if(l<1){n+=Ed11y.M.errorOutlinePrefixHeadingEmpty;i="headingEmpty";a=false;s.push({element:e,test:i,content:Ed11y.M.headingEmpty.tip(),position:c,dismissalKey:a})}else if(l>160){n+=Ed11y.M.errorOutlinePrefixHeadingIsLong;a=Ed11y.dismissalKey(t+o);i="headingIsLong";s.push({element:e,test:i,content:Ed11y.M.headingIsLong.tip(),position:c,dismissalKey:a})}if(i!=="headingEmpty"&&d>0&&t-d>1){a=Ed11y.dismissalKey(t+o);n+=Ed11y.M.errorOutlinePrefixSkippedLevel;i="headingLevelSkipped";s.push({element:e,test:i,content:Ed11y.M.headingLevelSkipped.tip(d,t),position:c,dismissalKey:a})}d=t;if(Ed11y.elements.h?.includes(e)){Ed11y.headingOutline.push([e,t,n,a]);s?.forEach(e=>{Ed11y.results.push(e)})}else if(!Ed11y.options.headingsOnlyFromCheckRoots){Ed11y.headingOutline.push([e,t,"",a])}});Ed11y.elements.blockquote?.forEach(i=>{if(!Ed11y.addedNodeReadyToCheck(i)){return}let n=Ed11y.getText(i);if(n&&n.length<25){let e=Ed11y.dismissalKey(n);let t="blockquoteIsShort";let s=Ed11y.M.blockquoteIsShort.tip();Ed11y.results.push({element:i,test:t,content:s,position:c,dismissalKey:e})}})}}class Ed11yTestImages{check(){Ed11y.imageAlts=[];Ed11y.elements.img.forEach(s=>{let i=s.matches("[aria-label], [aria-labelledby]")?Ed11y.computeText(s):s.getAttribute("alt");let e=Ed11y.M.altLabelPrefix;let n=s.getAttribute("src");let o="";let l=true;let a=Ed11y.parentLink(s);if(typeof i!=="string"){o="altMissing";l=false;e+=Ed11y.M.errorAltMissing}else if(!!Ed11y.options.altPlaceholder&&i.indexOf(Ed11y.options.altPlaceholder)!==-1||i.length===0&&!a){o="altNull";e+=Ed11y.M.errorAltNull}else{e+=i;const t=i.toLowerCase().trim();if(Ed11y.M.meaninglessAlt.includes(t)){o="altMeaningless";l=false}else{let e=[".avi",".png",".jp",".webp",".gif",".tiff",".svg",".hei","://"];let s=[null,null];e.forEach(e=>{if(t.indexOf(e)>=0){s[0]="URL"}});if(!s[0]){let e=Ed11y.M.suspiciousWords;const r=t.replace(".","");e.some(e=>{const t=r.indexOf(e);if(t>-1&&t<6){s[1]=e;return true}});if(!s[1]){Ed11y.M.badEndingForAlt.some(e=>{if(r.endsWith(e)){s[1]=e;return true}})}}if(s[0]==="URL"){o="altURL";l=false}else if(s[1]!==null){o="altImageOf"}else if(!a&&i!==""&&i.replace(/"|'|\?|\.|-|\s+/g,"")===""){o="altDeadspace";l=false}else if(i.length>160){o="altLong"}}if(a!==null){s=a;if(!o&&i!==""){let e=Ed11y.computeText(s,0,!!Ed11y.options.linkIgnoreSelector);e=e.replace(i.trim(),"");if(Ed11y.options.linkStringsNewWindows&&Ed11y.options.linkStringsNewWindows!==Ed11y.M.linkStringsNewWindows){e=e.toLowerCase().replace(Ed11y.options.linkIgnoreStrings,"")}if(Ed11y.options.linkIgnoreStrings){e=Ed11y.options.linkIgnoreStrings?e.toLowerCase().replace(Ed11y.options.linkIgnoreStrings,""):e.toLowerCase()}e=e.replace(/"|'|\?|\.|-|\s+/g,"");if(e.length>0){o="altPartOfLinkWithText"}}else{o=o?o+"Linked":o}}}let d="pass";if(o){let e=n?n.split("?")[0]:"nosrc_";l=l?Ed11y.dismissalKey(e+i):false;if(o==="altPartOfLinkWithText"){let e=Ed11y.computeText(a);if(e&&i){i=e.replace(i.trim(),` (Image: ${i}) `).trim()}}let t=Ed11y.options.langSanitizes?Ed11y.M[o].tip(i):Ed11y.M[o].tip(Ed11y.sanitizeForHTML(i));Ed11y.results.push({element:s,test:o,content:t,position:"beforebegin",dismissalKey:l});d=l===false?"ed11y-error":"ed11y-warning"}Ed11y.imageAlts.push([s,n,e,d])})}}class Ed11yTestLinks{check(){Ed11y.elements.a?.forEach(s=>{let i=Ed11y.computeText(s,0,!!Ed11y.options.linkIgnoreSelector);let e=s.querySelectorAll("img");let n=e.length>0;let t=s.matches(Ed11y.options.documentLinks);if(s?.getAttribute("target")==="_blank"){if(!(Ed11y.options.linkIgnoreSelector&&s?.querySelector(Ed11y.options.linkIgnoreSelector)||i.toLowerCase().match(Ed11y.options.linkStringsNewWindows))){let e=Ed11y.dismissalKey(i);Ed11y.results.push({element:s,test:"linkNewWindow",content:Ed11y.M.linkNewWindow.tip(),position:"beforebegin",dismissalKey:e})}}if(i.replace(/"|'|\?|\.|-|\s+/g,"").length===0&&!(Ed11y.options.linkIgnoreSelector&&s.querySelector(Ed11y.options.linkIgnoreSelector))){if(n===false){Ed11y.results.push({element:s,test:"linkNoText",content:Ed11y.M.linkNoText.tip(),position:"beforebegin",dismissalKey:false})}else{Ed11y.results.push({element:s,test:"altEmptyLinked",content:Ed11y.M.altEmptyLinked.tip(),position:"beforebegin",dismissalKey:false})}}else{let e=function(t){let e=t.toLowerCase();if(Ed11y.options.linkStringsNewWindows&&Ed11y.options.linkStringsNewWindows!==Ed11y.M.linkStringsNewWindows){e=e.replace(Ed11y.options.linkIgnoreStrings,"")}if(Ed11y.options.linkIgnoreStrings){e=Ed11y.options.linkIgnoreStrings?e.replace(Ed11y.options.linkIgnoreStrings,""):e}if(e.replace(/"|'|\?|\.|-|\s+/g,"").length===0){return"generic"}let s=Ed11y.options.linksUrls?Ed11y.options.linksUrls:Ed11y.M.linksUrls;let i=Ed11y.options.linksMeaningless?Ed11y.options.linksMeaningless:Ed11y.M.linksMeaningless;let n="none";if(e.replace(i,"").length===0){n="generic"}else{for(let e=0;e<s.length;e++){if(t.indexOf(s[e])>-1){n="url";break}}}return n};let t=e(i);if(t!=="none"){let e=false;if(!n&&t==="url"){e="linkTextIsURL"}if(t==="generic"){e="linkTextIsGeneric";if(i.length<4){i=Ed11y.computeText(s,0)}}if(e){Ed11y.results.push({element:s,test:e,content:Ed11y.M[e].tip(Ed11y.sanitizeForHTML(i)),position:"beforebegin",dismissalKey:Ed11y.dismissalKey(i)})}}}if(t){let e=Ed11y.dismissalKey(s?.getAttribute("href"));Ed11y.results.push({element:s,test:"linkDocument",content:Ed11y.M.linkDocument.tip(),position:"beforebegin",dismissalKey:e})}})}}class Ed11yTestText{check(){const r=new RegExp(/(([023456789][\d\s])|(1\d))/,"");const c=new RegExp(/(^[aA1]|[^\p{Alphabetic}\s])[-\s.)]/,"u");const y=new RegExp(/\p{Extended_Pictographic}|[•*]/,"u");const u=["a","A","1"];const t={b:"a",B:"A",2:"1"};const p=function(e){return e.replace(/^b|^B|^2/,function(e){return t[e]})};let h="";let m="";let E=false;Ed11y.elements.p?.forEach((i,e)=>{let s=false;let n=false;m=m?m:Ed11y.getText(i).replace("(","");let o=m.substring(0,2);const l=o.match(c)!==null;const t=o.match(r)!==null;const a=o.match(y)!==null;if(o.length>0&&(o!==h||E&&a)&&!t&&(l||a)){let t=Ed11y.elements.p[e+1];e:if(t){s=Ed11y.getText(t).replace("(","").substring(0,2);if(u.includes(s?.toLowerCase().trim())){break e}let e=p(s);if(l){if(o!=="A "&&o===e){n=true}}else if(a&&!E){if(e.match(y)){n=true;E=true}}}if(!n){let e=i?.querySelector("br")?.nextSibling?.nodeValue;if(e){e=e.replace(/<\/?[^>]+(>|$)/g,"").replace("(","").trim().substring(0,2);if(o===p(e)||!l&&!E&&e.match(y)){n=true}}}if(n){let e=Ed11y.dismissalKey(m);const d=/[•*-1aA]/.test(o)?o.substring(0,1):o;Ed11y.results.push({element:i,test:"textPossibleList",content:Ed11y.options.langSanitizes?Ed11y.M.textPossibleList.tip(o):Ed11y.M.textPossibleList.tip(Ed11y.sanitizeForHTML(d)),position:"afterbegin",dismissalKey:e});h=o}else{h=""}}else{let s=i.querySelector("strong:not(table strong), b:not(table b)");if(s&&!i.querySelector("a")){s=Ed11y.getText(s);let e=s.length;let t=s.match(/[.:;?!"']/)!==null;if(121>e&&e>5&&e===m.length&&t===false){let e=Ed11y.dismissalKey(s);Ed11y.results.push({element:i,test:"textPossibleHeading",content:Ed11y.M.textPossibleHeading.tip(),position:"afterbegin",dismissalKey:e})}}}if(!(a&&E)){E=false}m=s?"":s});let s=function(s){let i="";if(s.tagName==="LI"){s.childNodes.forEach(e=>{if(e.nodeType===3){i+=e.textContent}})}else{i=Ed11y.getText(s)}let e=/([A-Z]{2,}[ ])([A-Z]{2,}[ ])([A-Z]{2,}[ ])([A-Z]{2,})/g;let t=i.match(e);if(t&&t[0].length>10){let e=Ed11y.dismissalKey(i);let t=s.closest("a, button");if(t){Ed11y.results.push({element:t,test:"textUppercase",content:Ed11y.M.textUppercase.tip(),position:"beforebegin",dismissalKey:e})}else{Ed11y.results.push({element:s,test:"textUppercase",content:Ed11y.M.textUppercase.tip(),position:"afterbegin",dismissalKey:e})}}};Ed11y.elements.h?.forEach(e=>{s(e)});Ed11y.elements.p?.forEach(e=>{s(e)});Ed11y.elements.blockquote?.forEach(e=>{s(e)});Ed11y.elements.li?.forEach(e=>{s(e)});Ed11y.elements.table.forEach(e=>{if(!Ed11y.addedNodeReadyToCheck(e)){return}let t=e.querySelectorAll("th");let s=e.querySelectorAll("h1, h2, h3, h4, h5, h6");if(t.length===0){Ed11y.results.push({element:e,test:"tableNoHeaderCells",content:Ed11y.M.tableNoHeaderCells.tip(),position:"beforebegin",dismissalKey:false})}else{Array.from(t).some(e=>{if(Ed11y.computeText(e).length<1){if(e.matches("th + th, tr + tr th")){Ed11y.results.push({element:e,test:"tableEmptyHeaderCell",content:Ed11y.M.tableEmptyHeaderCell.tip(),position:"afterbegin",dismissalKey:false});return true}else{Ed11y.results.push({element:e,test:"tableEmptyHeaderCell",content:Ed11y.M.tableEmptyHeaderCell.tip(),position:"afterbegin",dismissalKey:Ed11y.dismissalKey(e.closest("tr")?.innerHTML)})}}})}if(s){s.forEach(e=>{Ed11y.results.push({element:e,test:"tableContainsContentHeading",content:Ed11y.M.tableContainsContentHeading.tip(),position:"beforebegin",dismissalKey:false})})}})}}class Ed11y{constructor(e){Ed11y.version="2.4.4";let t={cssUrls:false,checkRoots:false,fixedRoots:false,shadowComponents:false,autoDetectShadowComponents:true,ignoreElements:false,ignoreTests:false,ignoreAriaOnElements:false,ignoreTextInElements:false,ignoreByKey:{p:"table p",img:"[aria-hidden], [aria-hidden] img, "+'[role="presentation"], '+"a[href][aria-label] img, button[aria-label] img, "+"a[href][aria-labelledby] img, button[aria-labelledby] img",a:"[aria-hidden][tabindex]",table:'[role="presentation"]'},headingsOnlyFromCheckRoots:false,alertMode:"userPreference",inlineAlerts:true,watchForChanges:true,editableContent:'[contenteditable="true"]:not(.gutenberg__editor [contenteditable]), .gutenberg__editor .interface-interface-skeleton__content',currentPage:false,allowHide:true,allowOK:true,syncedDismissals:false,reportsURL:false,showDismissed:false,ignoreAllIfAbsent:false,ignoreAllIfPresent:false,preventCheckingIfPresent:false,preventCheckingIfAbsent:false,linkIgnoreStrings:false,linkIgnoreSelector:false,checkVisible:true,hiddenHandlers:"",panelPinTo:"right",panelOffsetX:"25px",panelOffsetY:"25px",panelNoCover:"",panelAttachTo:document.body,constrainButtons:false,lang:"en",langSanitizes:false,theme:"sleekTheme",sleekTheme:{bg:"#eff2ff",bgHighlight:"#7b1919",text:"#20160c",primary:"#276499",primaryText:"#eff2ff",button:"transparent",panelBar:"#1e517c",panelBarText:"#fffdf7",panelBarShadow:"0 0 0 1px #276499",activeTab:"#276499",activeTabText:"#fffffe",focusRing:"#007aff",outlineWidth:"0",borderRadius:"3px",ok:"#1f5381",warning:"rgb(250, 216, 89)",warningText:"#20160c",alert:"rgb(184, 5, 25)",alertText:"#f4f7ff"},darkTheme:{bg:"#0a2051",bgHighlight:"#7b1919",text:"#f4f7ff",primary:"#3052a0",primaryText:"#f4f7ff",button:"transparent",panelBar:"#3052a0",panelBarText:"#f4f7ff",panelBarShadow:"inset 0 0 1px, 0 0 0 1px #0a2051",activeTab:"#0a2051",activeTabText:"#fffffe",focusRing:"cyan",outlineWidth:"2px",borderRadius:"3px",ok:"#0a307a",warning:"rgb(250, 216, 89)",warningText:"#20160c",alert:"rgb(184, 5, 25)",alertText:"#f4f7ff"},lightTheme:{bg:"#fffffe",bgHighlight:"#7b1919",text:"#20160c",primary:"#0a307a",primaryText:"#fffdf7",panelBar:"#0a307a",panelBarText:"#f4f7ff",panelBarShadow:"0 0 0 1px #0a307a",button:"transparent",activeTab:"#b9c0cf",activeTabText:"#20160c",focusRing:"#007aff",outlineWidth:"0",borderRadius:"3px",ok:"#0a307a",warning:"rgb(250, 216, 89)",warningText:"#20160c",alert:"rgb(184, 5, 25)",alertText:"#f4f7ff"},buttonZIndex:1299,baseFontSize:"clamp(14px, 1.5vw, 16px)",baseFontFamily:'-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif',embeddedContent:false,embeddedContentTitle:"",embeddedContentMessage:"",videoContent:"youtube.com, vimeo.com, yuja.com, panopto.com",audioContent:"soundcloud.com, simplecast.com, podbean.com, buzzsprout.com, blubrry.com, transistor.fm, fusebox.fm, libsyn.com",dataVizContent:"datastudio.google.com, tableau",twitterContent:"twitter-timeline",documentLinks:"a[href$='.pdf'], a[href*='.pdf?']",linksUrls:false,linksMeaningless:false,altPlaceholder:false,editLinks:false,editorHeadingLevel:[{selector:"*",previousHeading:0}],userPrefersShut:localStorage.getItem("editoria11yShow")==="0",customTests:0};Ed11y.options={...t,...e};Ed11y.M={...ed11yLang["en"],...ed11yLang[Ed11y.options.lang]};Ed11y.theme=Ed11y.options[Ed11y.options.theme];Ed11y.theme.baseFontSize=Ed11y.options.baseFontSize;Ed11y.theme.buttonZIndex=Ed11y.options.buttonZIndex;Ed11y.theme.baseFontFamily=Ed11y.options.baseFontFamily;if(Ed11y.options.currentPage===false){Ed11y.options.currentPage=window.location.pathname}if(!Ed11y.options.linkStringsNewWindows){Ed11y.options.linkStringsNewWindows=Ed11y.M.linkStringsNewWindows}if(!Ed11y.options.cssUrls){const w=document.querySelector('link[href*="editoria11y.css"], link[href*="editoria11y.min.css"]');if(w){Ed11y.options.cssUrls=[w.getAttribute("href")]}else{console.warn("Editoria11y CSS file parameter is missing; attempting to load from CDN.");Ed11y.options.cssUrls=[`https://cdn.jsdelivr.net/gh/itmaybejj/editoria11y@${Ed11y.version}/dist/editoria11y.min.css`]}}const s=document.createElement("div");s.classList.add("ed11y-style");s.setAttribute("hidden","");Ed11y.options.cssUrls?.forEach(e=>{const t=document.createElement("link");t.setAttribute("rel","stylesheet");t.setAttribute("media","all");if(e.indexOf("?")<0){e=e+"?ver="+Ed11y.version}t.setAttribute("href",e);s.append(t)});Ed11y.attachCSS=function(e){e.appendChild(s.cloneNode(true))};Ed11y.elements=[];Ed11y.onLoad=true;Ed11y.showPanel=false;let S=window.innerWidth;Ed11y.watching=[];Ed11y.disable=()=>{if(Ed11y.open&&!Ed11y.closedByDisable){Ed11y.closedByDisable=true}Ed11y.disabled=true;Ed11y.reset();document.documentElement.style.setProperty("--ed11y-activeBackground",Ed11y.theme.panelBar);document.documentElement.style.setProperty("--ed11y-activeColor",Ed11y.theme.panelBarText);document.documentElement.style.setProperty("--ed11y-activeBorder",Ed11y.theme.panelBarText+"44");document.documentElement.style.setProperty("--ed11y-activePanelBorder","transparent");if(Ed11y.panelToggle){Ed11y.panel?.classList.remove("ed11y-errors","ed11y-warnings");Ed11y.panelCount.textContent="i";Ed11y.panelJumpNext.setAttribute("hidden","");Ed11y.panelToggle.classList.add("disabled");Ed11y.panelToggle.querySelector(".ed11y-sr-only").textContent=Ed11y.M.toggleDisabled}};Ed11y.initialize=()=>{if(Ed11y.once){console.error("double init");return}Ed11y.once=true;Ed11y.checkRunPrevent=()=>{let e=Ed11y.options.preventCheckingIfPresent?document.querySelector(Ed11y.options.preventCheckingIfPresent):false;if(e){console.warn(`Editoria11y is disabled because an element matched the "preventCheckingIfPresent" parameter:  "${Ed11y.options.preventCheckingIfPresent}"`)}else if(!e&&!!Ed11y.options.preventCheckingIfAbsent){e=document.querySelector(`:is(${Ed11y.options.preventCheckingIfAbsent})`)===null;if(e){console.warn(`Editoria11y is disabled because no elements matched the "preventCheckingIfAbsent" parameter: "${Ed11y.options.preventCheckingIfAbsent}"`)}}return e};const e=e=>{if(document.readyState==="complete"){e()}else{window.addEventListener("load",e)}};e(()=>{if(Ed11y.checkRunPrevent()){return false}Ed11y.running=true;let e=localStorage.getItem("editoria11yResultCount");Ed11y.seen=e?JSON.parse(e):{};if(Ed11y.options.syncedDismissals===false){Ed11y.dismissedAlerts=localStorage.getItem("ed11ydismissed");Ed11y.dismissedAlerts=Ed11y.dismissedAlerts?JSON.parse(Ed11y.dismissedAlerts):{}}else{Ed11y.dismissedAlerts={};Ed11y.dismissedAlerts[Ed11y.options.currentPage]=Ed11y.options.syncedDismissals}Ed11y.testEmbeds=new Ed11yTestEmbeds;Ed11y.testHeadings=new Ed11yTestHeadings;Ed11y.testImages=new Ed11yTestImages;Ed11y.testLinks=new Ed11yTestLinks;Ed11y.testText=new Ed11yTestText;Ed11y.ignore=Ed11y.options.ignoreElements?`:not(${Ed11y.options.ignoreElements})`:"";if(!Ed11y.options.checkRoots){Ed11y.options.checkRoots=document.querySelector("main")!==null?"main":"body"}Ed11y.checkAll();window.addEventListener("resize",function(){Ed11y.windowResize()})})};Ed11y.results=[];Ed11y.checkAll=()=>{if(Ed11y.openTip.button){return false}Ed11y.disabled=false;if(!Ed11y.checkRunPrevent()){Ed11y.ignoreAll=Ed11y.options.ignoreAllIfAbsent&&document.querySelector(`:is(${Ed11y.options.ignoreAllIfAbsent})`)===null;if(!Ed11y.ignoreAll&&!!Ed11y.options.ignoreAllIfPresent){Ed11y.ignoreAll=document.querySelector(`:is(${Ed11y.options.ignoreAllIfPresent})`)!==null}if(Ed11y.incremental){Ed11y.oldResults=Ed11y.results}Ed11y.results=[];Ed11y.elements=[];Ed11y.mediaCount=0;Ed11y.customTestsRunning=false;let t=[];if(Ed11y.options.fixedRoots){Ed11y.options.fixedRoots.forEach(e=>{t.push(e.fixedRoot)})}else{t=document.querySelectorAll(`:is(${Ed11y.options.checkRoots})`)}if(t.length===0){if(Ed11y.onLoad){console.warn("Check Editoria11y configuration; specified root element not found")}Ed11y.disable();return}else{Ed11y.roots=[];t.forEach((e,t)=>{if(e.shadowRoot){Ed11y.roots[t]=e.shadowRoot;e.setAttribute("data-ed11y-has-shadow-root","true");Ed11y.detectShadow(e.shadowRoot)}else{Ed11y.roots[t]=e;Ed11y.detectShadow(e)}if(Ed11y.options.fixedRoots){e.dataset.ed11yRoot=`${t}`}});Ed11y.buildElementList();let e=["testLinks","testImages","testHeadings","testText","testEmbeds"];e.forEach(e=>{window.setTimeout(function(e){Ed11y[e].check()},0,e)});if(Ed11y.options.customTests>0){Ed11y.customTestsRunning=true;Ed11y.customTestsFinished=0;document.addEventListener("ed11yResume",function(){Ed11y.customTestsFinished++;if(Ed11y.customTestsFinished===Ed11y.options.customTests){Ed11y.customTestsRunning=false;window.requestAnimationFrame(()=>Ed11y.updatePanel())}});window.setTimeout(function(){if(Ed11y.customTestsRunning===true){Ed11y.customTestsRunning=false;if(Ed11y.panelToggle){Ed11y.panelToggle.querySelector(".ed11y-sr-only").textContent=Ed11y.M.toggleAccessibilityTools}window.requestAnimationFrame(()=>Ed11y.updatePanel());console.error("Editoria11y was told to wait for custom tests, but no tests were returned.")}},1e3);window.setTimeout(function(){let e=new CustomEvent("ed11yRunCustomTests");document.dispatchEvent(e)},0)}}if(!Ed11y.customTestsRunning){window.setTimeout(function(){if(Ed11y.panelToggle){Ed11y.panelToggle.querySelector(".ed11y-sr-only").textContent=Ed11y.M.toggleAccessibilityTools}Ed11y.updatePanel()},0)}}else{Ed11y.disable()}};Ed11y.totalCount=0;Ed11y.countAlerts=function(){Ed11y.errorCount=0;Ed11y.warningCount=0;Ed11y.dismissedCount=0;Ed11y.dismissedCount=0;for(let s=Ed11y.results.length-1;s>=0;s--){let e=Ed11y.results[s].test;if(Ed11y.options.ignoreTests&&Ed11y.options.ignoreTests.includes(e)){Ed11y.results.splice(s,1);continue}let t=Ed11y.dismissalKey(Ed11y.results[s].dismissalKey);if(t!==false&&Ed11y.options.currentPage in Ed11y.dismissedAlerts&&e in Ed11y.dismissedAlerts[Ed11y.options.currentPage]&&t in Ed11y.dismissedAlerts[Ed11y.options.currentPage][e]){Ed11y.dismissedCount++;Ed11y.results[s].dismissalStatus=Ed11y.dismissedAlerts[Ed11y.options.currentPage][e][t]}else if(Ed11y.results[s].dismissalKey){Ed11y.warningCount++;Ed11y.results[s].dismissalStatus=false}else{Ed11y.errorCount++;Ed11y.results[s].dismissalStatus=false}}Ed11y.totalCount=Ed11y.errorCount+Ed11y.warningCount;if(!Ed11y.incremental){window.setTimeout(function(){let e=new CustomEvent("ed11yResults");document.dispatchEvent(e)},0)}if(Ed11y.ignoreAll){Ed11y.dismissedCount=Ed11y.totalCount+Ed11y.dismissedCount;Ed11y.errorCount=0;Ed11y.warningCount=0;Ed11y.totalCount=0}};let i="";const n=function(){if(Ed11y.forceFullCheck||Ed11y.results.length!==Ed11y.oldResults.length){return true}let t=`${Ed11y.errorCount} ${Ed11y.warningCount}`;Ed11y.results.forEach(e=>{t+=e.test+e.element.outerHTML});let e=t!==i;i=t;return e};Ed11y.updatePanel=function(){Ed11y.countAlerts();if(Ed11y.incremental){if(Ed11y.forceFullCheck||n()){Ed11y.forceFullCheck=false;Ed11y.resetResults()}else{Ed11y.results=Ed11y.oldResults;window.setTimeout(function(){if(!Ed11y.alignPending){Ed11y.alignButtons();Ed11y.alignPanel();Ed11y.alignPending=false}Ed11y.running=false},0);return}}else{if(Ed11y.totalCount>0){Ed11y.seen[encodeURI(Ed11y.options.currentPage)]=Ed11y.totalCount;localStorage.setItem("editoria11yResultCount",JSON.stringify(Ed11y.seen))}else{delete Ed11y.seen[encodeURI(Ed11y.options.currentPage)]}}if(Ed11y.options.alertMode!=="headless"){if(!Ed11y.bodyStyle){Ed11y.paintReady()}if(Ed11y.onLoad===true){Ed11y.onLoad=false;if(!Ed11y.options.inlineAlerts){i=`${Ed11y.errorCount} ${Ed11y.warningCount}`;Ed11y.results.forEach(e=>{i+=e.test+e.element.outerHTML})}let e=document.createElement("ed11y-element-panel");e.classList.add("ed11y-preload");document.body.appendChild(e);Ed11y.attachCSS(Ed11y.panel);window.setTimeout(()=>{e.classList.remove("ed11y-preload")},0,e);Ed11y.panel.querySelector("#ed11y-visualize .ed11y-sr-only").textContent=Ed11y.M.buttonToolsContent;Ed11y.panel.querySelector("#ed11y-headings-tab .summary-title").textContent=Ed11y.M.buttonOutlineContent;Ed11y.panel.querySelector("#ed11y-headings-tab .details-title").innerHTML=Ed11y.M.panelCheckOutline;Ed11y.panel.querySelector("#ed11y-alts-tab .summary-title").textContent=Ed11y.M.buttonAltsContent;Ed11y.panel.querySelector("#ed11y-alts-tab .details-title").innerHTML=Ed11y.M.panelCheckAltText;Ed11y.panel.querySelector(".jump-next.ed11y-sr-only").textContent=Ed11y.M.buttonFirstContent;Ed11y.panel.setAttribute("aria-label",Ed11y.M.panelControls);if(Ed11y.options.reportsURL){let e=document.createElement("a");e.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M0 96C0 61 29 32 64 32l384 0c35 0 64 29 64 64l0 320c0 35-29 64-64 64L64 480c-35 0-64-29-64-64L0 96zm64 0l0 64 64 0 0-64L64 96zm384 0L192 96l0 64 256 0 0-64zM64 224l0 64 64 0 0-64-64 0zm384 0l-256 0 0 64 256 0 0-64zM64 352l0 64 64 0 0-64-64 0zm384 0l-256 0 0 64 256 0 0-64z"/></svg><span class="ed11y-sr-only"></span>';e.setAttribute("id","ed11y-reports-link");e.setAttribute("href",Ed11y.options.reportsURL);e.setAttribute("target","_blank");e.setAttribute("aria-label",Ed11y.M.reportsLink);e.querySelector(".ed11y-sr-only").textContent=Ed11y.M.reportsLink;Ed11y.showDismissed.insertAdjacentElement("beforebegin",e)}if(Ed11y.ignoreAll||!Ed11y.options.inlineAlerts&&Ed11y.totalCount>75){Ed11y.showPanel=false}else if(Ed11y.options.alertMode==="active"||!Ed11y.options.userPrefersShut||Ed11y.options.showDismissed){Ed11y.showPanel=true}else if(Ed11y.totalCount>0&&!Ed11y.ignoreAll&&(Ed11y.options.alertMode==="assertive"||Ed11y.options.alertMode==="polite"&&Ed11y.seen[encodeURI(Ed11y.options.currentPage)]!==Ed11y.totalCount)){Ed11y.showPanel=true}}if(!Ed11y.showPanel){Ed11y.reset()}else{Ed11y.open=true;Ed11y.panel.classList.remove("ed11y-shut");Ed11y.panel.classList.add("ed11y-active");Ed11y.panelToggle.setAttribute("aria-expanded","true");Ed11y.panelToggleTitle.textContent=Ed11y.totalCount>0?Ed11y.M.buttonHideAlerts:Ed11y.M.buttonHideChecker;if(Ed11y.dismissedCount===0){Ed11y.showDismissed.setAttribute("hidden","");Ed11y.showDismissed.setAttribute("data-ed11y-pressed","false");Ed11y.options.showDismissed=false}else if(Ed11y.dismissedCount===1){Ed11y.showDismissed.querySelector(".ed11y-sr-only").textContent=Ed11y.options.showDismissed?Ed11y.M.buttonHideHiddenAlert:Ed11y.M.buttonShowHiddenAlert;Ed11y.showDismissed.dataset.ed11yPressed=`${Ed11y.options.showDismissed}`;Ed11y.showDismissed.removeAttribute("hidden")}else{Ed11y.showDismissed.querySelector(".ed11y-sr-only").textContent=Ed11y.options.showDismissed?Ed11y.M.buttonHideHiddenAlerts(Ed11y.dismissedCount):Ed11y.M.buttonShowHiddenAlerts(Ed11y.dismissedCount);Ed11y.showDismissed.dataset.ed11yPressed=`${Ed11y.options.showDismissed}`;Ed11y.showDismissed.removeAttribute("hidden")}window.setTimeout(function(){if(!Ed11y.ignoreAll){requestAnimationFrame(()=>Ed11y.showResults())}},0)}if(Ed11y.totalCount>0||Ed11y.options.showDismissed&&Ed11y.dismissedCount>0){Ed11y.panelToggleTitle.textContent=Ed11y.open?Ed11y.M.buttonHideAlerts:Ed11y.M.buttonShowAlerts;Ed11y.panelJumpNext.removeAttribute("hidden");if(Ed11y.errorCount>0){Ed11y.panel.classList.remove("ed11y-warnings","ed11y-pass");Ed11y.panel.classList.add("ed11y-errors");document.documentElement.style.setProperty("--ed11y-activeBackground",Ed11y.theme.alert);document.documentElement.style.setProperty("--ed11y-activeColor","#fff");document.documentElement.style.setProperty("--ed11y-activeBorder","#fff7");document.documentElement.style.setProperty("--ed11y-activePanelBorder","#def")}else if(Ed11y.warningCount>0){Ed11y.panel.classList.remove("ed11y-errors","ed11y-pass");Ed11y.panel.classList.add("ed11y-warnings");document.documentElement.style.setProperty("--ed11y-activeBackground",Ed11y.theme.warning);document.documentElement.style.setProperty("--ed11y-activeColor","#111");document.documentElement.style.setProperty("--ed11y-activeBorder","#947605");document.documentElement.style.setProperty("--ed11y-activePanelBorder","#947605")}else{Ed11y.panel.classList.remove("ed11y-errors","ed11y-warnings");Ed11y.panel.classList.add("ed11y-pass");document.documentElement.style.setProperty("--ed11y-activeBackground",Ed11y.theme.panelBar);document.documentElement.style.setProperty("--ed11y-activeColor",Ed11y.theme.panelBarText);document.documentElement.style.setProperty("--ed11y-activeBorder",Ed11y.theme.panelBarText+"44");document.documentElement.style.setProperty("--ed11y-activePanelBorder",Ed11y.theme.panelBarText+"88")}if(Ed11y.dismissedCount>0&&Ed11y.totalCount===0){Ed11y.panelCount.textContent=Ed11y.dismissedCount}else{Ed11y.panelCount.textContent=Ed11y.totalCount>99?"99+":Ed11y.totalCount}}else{Ed11y.panelJumpNext.setAttribute("hidden","");document.documentElement.style.setProperty("--ed11y-activeBackground",Ed11y.theme.panelBar);document.documentElement.style.setProperty("--ed11y-activeColor",Ed11y.theme.panelBarText);document.documentElement.style.setProperty("--ed11y-activeBorder",Ed11y.theme.panelBarText+"44");document.documentElement.style.setProperty("--ed11y-activePanelBorder",Ed11y.theme.panelBarText+"88");Ed11y.panelCount.style.display="display: none;";Ed11y.panel.classList.remove("ed11y-warnings","ed11y-errors");Ed11y.panel.classList.add("ed11y-pass");if(Ed11y.dismissedCount>0){Ed11y.panelCount.textContent="i";if(Ed11y.open){Ed11y.panelToggleTitle.textContent=Ed11y.M.buttonHideChecker}else{Ed11y.panelToggleTitle.textContent=Ed11y.dismissedCount>1?Ed11y.M.buttonShowHiddenAlerts(Ed11y.dismissedCount):Ed11y.M.buttonShowHiddenAlert}}else{Ed11y.panelToggleTitle.textContent=Ed11y.open?Ed11y.M.buttonHideChecker:Ed11y.M.buttonShowNoAlert}}Ed11y.panelToggle.classList.remove("disabled");Ed11y.panelToggle.removeAttribute("aria-disabled");Ed11y.alignPanel();Ed11y.panel.classList.remove("ed11y-preload")}window.setTimeout(()=>{if(Ed11y.options.watchForChanges){Ed11y.elements.editable?.forEach(e=>{if(!e.matches(".drag-observe")){e.classList.add("drag-observe");e.addEventListener("drop",()=>{Ed11y.forceFullCheck=true;Ed11y.incrementalCheck()})}});if(Ed11y.options.watchForChanges==="checkRoots"){Ed11y.roots?.forEach(e=>{f(e)})}else{f(document.body)}Ed11y.resumeObservers()}},0);Ed11y.running=false};Ed11y.result=function(e,t){let s=document.createElement("ed11y-element-result");s.classList.add("ed11y-element");let i;let n="beforebegin";s.setAttribute("id","ed11y-result-"+t);s.setAttribute("data-ed11y-result",t);s.setAttribute("data-ed11y-open","false");if(!Ed11y.options.inlineAlerts){i=Ed11y.options.panelAttachTo;n="beforeend";s.classList.add("ed11y-editable-result")}else{i=e.element.closest('a, button, [role="button"], [role="link"]');if(!i&&e.element.shadowRoot){i=e.element;n="beforebegin";while(i.parentElement&&i.parentElement.shadowRoot){i=i.parentElement}}if(!i){i=e.element;n=e.position}}i.insertAdjacentElement(n,s);Ed11y.jumpList.unshift(s);Ed11y.results[t].toggle=s};Ed11y.resetResults=function(){Ed11y.jumpList=[];Ed11y.openTip={button:false,tip:false};Ed11y.lastOpenTip=-1;Ed11y.resetClass(["ed11y-ring-red","ed11y-ring-yellow","ed11y-hidden-highlight","ed11y-warning-inline","ed11y-warning-block","ed11y-error-block","ed11y-error-inline"]);Ed11y.findElements("reset","ed11y-element-heading-label, ed11y-element-alt, ed11y-element-highlight",false);Ed11y.elements.reset?.forEach(e=>e.remove());Ed11y.findElements("delayedReset","ed11y-element-result, ed11y-element-tip",false);const e=Ed11y.elements.delayedReset;window.setTimeout(()=>{e?.forEach(e=>e.remove())},100,e);if(Ed11y.panelJumpNext){Ed11y.panelJumpNext.querySelector(".ed11y-sr-only").textContent=Ed11y.M.buttonFirstContent}};Ed11y.resetPanel=function(){Ed11y.visualizing=true;Ed11y.visualize();if(Ed11y.totalCount===0&&Ed11y.dismissedCount>0){Ed11y.panelCount.textContent="i";Ed11y.panelToggleTitle.textContent=Ed11y.dismissedCount===1?Ed11y.M.buttonShowHiddenAlert:Ed11y.M.buttonShowHiddenAlerts(Ed11y.dismissedCount)}if(!Ed11y.options.showDismissed&&Ed11y.showDismissed){Ed11y.showDismissed.setAttribute("data-ed11y-pressed","false");Ed11y.showDismissed.querySelector(".ed11y-sr-only").textContent=Ed11y.dismissedCount===1?Ed11y.M.buttonShowHiddenAlert:Ed11y.M.buttonShowHiddenAlerts(Ed11y.dismissedCount)}Ed11y.panel?.classList.add("ed11y-shut");Ed11y.panel?.classList.remove("ed11y-active");Ed11y.panelToggle?.setAttribute("aria-expanded","false")};Ed11y.reset=function(){Ed11y.pauseObservers();Ed11y.resetResults();Ed11y.resetPanel();Ed11y.incremental=false;Ed11y.running=false;Ed11y.showPanel=false;Ed11y.open=false};Ed11y.linkText=e=>{e=e.replace(Ed11y.options.linkIgnoreStrings,"");e=e.replace(/'|"|-|\.|\s+/g,"");return e};Ed11y.detectShadow=function(t){if(Ed11y.options.autoDetectShadowComponents){const s=!Ed11y.ignore?"*:not(.ed11y-element)":`*:not(${Ed11y.options.ignore}, .ed11y-element)`;let e=[];if(t.shadowRoot&&t.shadowRoot.mode==="open"){if(!t.matches("[data-ed11y-has-shadow-root]")){t.setAttribute("data-ed11y-has-shadow-root","true");Ed11y.attachCSS(t.shadowRoot);Ed11y.attachCSS(t)}e=t.shadowRoot.querySelectorAll(s)}else{e=t.querySelectorAll(s)}e?.forEach(e=>{if(e.shadowRoot&&e.shadowRoot.mode==="open"){Ed11y.detectShadow(e)}})}else if(Ed11y.options.shadowComponents){const e=t.querySelectorAll(Ed11y.options.shadowComponents);e.forEach(e=>{if(e.shadowRoot&&e.shadowRoot.mode==="open"){if(!t.matches("[data-ed11y-has-shadow-root]")){e.setAttribute("data-ed11y-has-shadow-root","true");Ed11y.attachCSS(e.shadowRoot);Ed11y.attachCSS(e)}Ed11y.detectShadow(e)}else{console.warn(`Editoria11y: A specified shadow host has no shadowRoot: ${e.tagName}`)}})}};const l=function(e,n,o){if(e.matches(o)){return[e]}else{let i=e.shadowRoot.querySelectorAll(n);if(typeof i==="object"&&i.length>0){i.forEach(s=>{for(let t=i-1;t>=0;t--){let e=l(s,n,o);if(e.length>0){i.splice(t,1,...e)}else{i.splice(t,1)}}});return Array.from(i).filter(e=>e.matches(o))}}return[]};Ed11y.findElements=function(s,i,e=true){let n=Ed11y.options.autoDetectShadowComponents?"[data-ed11y-has-shadow-root]":Ed11y.options.shadowComponents?Ed11y.options.shadowComponents:false;let t="";if(Ed11y.options.ignoreElements){t=Ed11y.options.ignoreByKey[s]?`:not(${Ed11y.options.ignoreElements}, ${Ed11y.options.ignoreByKey[s]})`:`:not(${Ed11y.options.ignoreElements})`}else{t=Ed11y.options.ignoreByKey[s]?`:not(${Ed11y.options.ignoreByKey[s]})`:""}Ed11y.elements[s]=[];const o=`:is(${i}${n?", "+n:""})${t}`;if(e&&Ed11y.roots){Ed11y.roots.forEach(e=>{Ed11y.elements[s]=Ed11y.elements[s].concat(Array.from(e.querySelectorAll(o)))})}else{Ed11y.elements[s]=Ed11y.elements[s].concat(Array.from(document.querySelectorAll(o)))}if(n){for(let t=Ed11y.elements[s].length-1;t>=0;t--){if(Ed11y.elements[s][t].matches(n)){let e=l(Ed11y.elements[s][t],o,i);if(e.length>0){Ed11y.elements[s].splice(t,1,...e)}else{Ed11y.elements[s].splice(t,1)}}}}};Ed11y.buildElementList=function(){if(typeof Ed11y.options.editableContent==="string"){Ed11y.findElements("editable",Ed11y.options.editableContent,false)}else{Ed11y.elements.editable=Ed11y.options.editableContent}if(Ed11y.options.inlineAlerts&&Ed11y.elements.editable.length>0){Ed11y.options.inlineAlerts=false;console.warn("Editable content detected; Editoria11y inline alerts disabled")}Ed11y.findElements("p","p");Ed11y.findElements("h",'h1, h2, h3, h4, h5, h6, [role="heading"][aria-level]');Ed11y.findElements("allH",'h1, h2, h3, h4, h5, h6, [role="heading"][aria-level]',Ed11y.options.fixedRoots?Ed11y.options.headingsOnlyFromCheckRoots:false);Ed11y.findElements("img","img");Ed11y.findElements("a","a[href]");Ed11y.findElements("li","li");Ed11y.findElements("blockquote","blockquote");Ed11y.findElements("iframe","iframe");Ed11y.findElements("audio","audio");Ed11y.findElements("video","video");Ed11y.findElements("table","table");if(Ed11y.options.embeddedContent){Ed11y.findElements("embed",Ed11y.options.embeddedContent)}if(Ed11y.options.panelNoCover){Ed11y.findElements("panelPin",Ed11y.options.panelNoCover,false)}};Ed11y.dismissalKey=function(e){return String(e).replace(/([^0-9a-zA-Z])/g,"").substring(0,512)};const a=function(e,s,i){if(e==="reset"){delete Ed11y.dismissedAlerts[Ed11y.options.currentPage][s][i];if(Object.keys(Ed11y.dismissedAlerts[Ed11y.options.currentPage][s]).length===0){delete Ed11y.dismissedAlerts[Ed11y.options.currentPage][s]}if(Object.keys(Ed11y.dismissedAlerts[Ed11y.options.currentPage]).length===0){delete Ed11y.dismissedAlerts[Ed11y.options.currentPage]}}else{let t={};t[i]=e;if(typeof Ed11y.dismissedAlerts[Ed11y.options.currentPage]=="undefined"){let e={};e[s]=t;Ed11y.dismissedAlerts[Ed11y.options.currentPage]=e}else if(typeof Ed11y.dismissedAlerts[Ed11y.options.currentPage][s]==="undefined"){Ed11y.dismissedAlerts[Ed11y.options.currentPage][s]=t}else{Ed11y.dismissedAlerts[Ed11y.options.currentPage][s][i]=e}Ed11y.showDismissed.removeAttribute("hidden")}if(Ed11y.options.syncedDismissals===false){localStorage.setItem("ed11ydismissed",JSON.stringify(Ed11y.dismissedAlerts))}let t={dismissPage:Ed11y.options.currentPage,dismissTest:s,dismissKey:i,dismissAction:e};let n=new CustomEvent("ed11yDismissalUpdate",{detail:t});window.setTimeout(()=>{document.dispatchEvent(n)},100)};Ed11y.dismissThis=function(t,e=false){let s=Ed11y.openTip;let i=s.tip.dataset.ed11yResult;let n=Ed11y.results[i].test;if(e){Ed11y.results.forEach(e=>{if(e.test===n&&e.dismissalStatus!==t){a(t,n,e.dismissalKey)}})}else{let e=Ed11y.dismissalKey(Ed11y.results[i].dismissalKey);a(t,n,e)}Ed11y.resetClass(["ed11y-hidden-highlight","ed11y-ring-red","ed11y-ring-yellow"]);s.tip?.parentNode?.removeChild(s.tip);Ed11y.reset();Ed11y.showPanel=true;Ed11y.checkAll();let o=Ed11y.lastOpenTip;window.setTimeout(function(){if(Ed11y.jumpList.length>0){Ed11y.lastOpenTip=o-1;Ed11y.panelJumpNext?.focus()}else{window.setTimeout(function(){Ed11y.panelToggle?.focus()},100)}},500,o)};Ed11y.transferFocus=function(){if(!Ed11y.openTip.tip){return}const e=Ed11y.openTip.tip.dataset.ed11yResult;const t=Ed11y.results[e].element;const s=t.closest("[contenteditable]");if(!s&&!t.closest("textarea, input")){if(t.closest("a")){Ed11y.toggledFrom=t.closest("a")}else if(t.getAttribute("tabindex")!==null){Ed11y.toggledFrom=t}else{t.setAttribute("tabindex","0");Ed11y.toggledFrom=t}Ed11y.openTip.tip.shadowRoot.querySelector(".close").click()}else{Ed11y.toggledFrom=false;if(t.getAttribute("contenteditable")==="true"){Ed11y.toggledFrom=t}else if(t.closest('p[contenteditable="true"]')){Ed11y.toggledFrom=t.closest('p[contenteditable="true"]')}else{Ed11y.toggledFrom=false}Ed11y.openTip.tip.shadowRoot.querySelector(".close").click();if(!Ed11y.toggledFrom&&s){s.focus();const i=document.createRange();const n=window.getSelection();i.setStart(t,0);i.collapse(true);n.removeAllRanges();n.addRange(i)}}};Ed11y.toggleShowDismissals=function(){Ed11y.ignoreAll=false;Ed11y.options.showDismissed=!Ed11y.options.showDismissed;Ed11y.reset();Ed11y.showPanel=true;Ed11y.checkAll();Ed11y.showDismissed.setAttribute("data-ed11y-pressed",(!!Ed11y.options.showDismissed).toString());window.setTimeout(function(){Ed11y.showDismissed.focus()},0)};Ed11y.showResults=function(){Ed11y.buildJumpList();document.dispatchEvent(new CustomEvent("ed11yPanelOpened"));Ed11y.alignButtons();if(!Ed11y.options.inlineAlerts){Ed11y.checkEditableIntersects();Ed11y.intersectionObservers()}};Ed11y.editableHighlight=[];Ed11y.alignHighlights=function(){if(Ed11y.options.fixedRoots&&Ed11y.editableHighlight.length>0){Ed11y.positionedFrames=[];Ed11y.options.fixedRoots.forEach(e=>{if(e["framePositioner"]){Ed11y.positionedFrames.push(e["framePositioner"].getBoundingClientRect())}})}Ed11y.editableHighlight.forEach(e=>{if(!Ed11y.results[e.resultID]){Ed11y.interaction=true;Ed11y.forceFullCheck=true;Ed11y.editableHighlight=[];Ed11y.incrementalCheck(true);return false}const t=Ed11y.results[e.resultID].fixedRoot&&Ed11y.positionedFrames[Ed11y.results[e.resultID].fixedRoot]?Ed11y.positionedFrames[Ed11y.results[e.resultID].fixedRoot]:{top:0,left:0};let s=e.target.getBoundingClientRect();if(!Ed11y.visible(e.target)){const i=Ed11y.firstVisibleParent(e.target);s=i?i.getBoundingClientRect():s}e.highlight.style.setProperty("width",s.width+6+"px");e.highlight.style.setProperty("top",s.top+t.top+window.scrollY-3+"px");e.highlight.style.setProperty("left",s.left+t.left-3+"px");e.highlight.style.setProperty("height",s.height+6+"px")})};Ed11y.editableHighlighter=function(e,t,s){if(!t){Ed11y.editableHighlight[e]?.highlight.style.setProperty("opacity","0");return}const i=Ed11y.results[e];let n=Ed11y.editableHighlight[e]?.highlight;if(!n){n=document.createElement("ed11y-element-highlight");n.classList.add("ed11y-element");Ed11y.editableHighlight[e]={highlight:n,resultID:e};n.style.setProperty("position","absolute");n.style.setProperty("pointer-events","none");Ed11y.options.panelAttachTo.appendChild(n)}Ed11y.editableHighlight[e].target=s?s:i.element;const o=i.dismissalKey?"calc(var(--ed11y-buttonZIndex, 9999) - 2)":"calc(var(--ed11y-buttonZIndex, 9999) - 1)";n.style.setProperty("z-index",o);const l=i.dismissalKey?"0 0 0 1px #fff, inset 0 0 0 2px var(--ed11y-warning, #fad859), 0 0 0 3px var(--ed11y-warning, #fad859), 0 0 0 4px var(--ed11y-primary)":"0 0 0 1px #fff, inset 0 0 0 2px var(--ed11y-alert, #b80519), 0 0 0 3px var(--ed11y-alert, #b80519), 0 0 1px 3px";n.style.setProperty("box-shadow",l);n.style.setProperty("border-radius","3px");n.style.setProperty("top","0");n.style.setProperty("left","0");Ed11y.alignHighlights();n.style.setProperty("opacity","1")};const y=function(t,s,i){if(t.style.transform){const n=window.getComputedStyle(t);let e=n.getPropertyValue("transform");e=e.split(",");t.style.transform=`translate(${parseFloat(e[4])+s}px, ${parseFloat(e[5])+i}px)`}else{t.style.transform=`translate(${s}px, ${i}px)`}};const o=function(e){let t=e.clientHeight&&e.clientHeight<e.scrollHeight;if(t){const s=window.getComputedStyle(e);t=s.overflowY!=="visible"}return t};const d=function(e){if(Ed11y.options.constrainButtons&&e.closest(Ed11y.options.constrainButtons)){return e.closest(Ed11y.options.constrainButtons)}let t=e.parentElement;if(t&&t.tagName!=="BODY"){if(o(t)){return t}else{t=d(t);return t}}else{return false}};const u=function(e,t,s,i,n=17){return!(e+n<s||e>s+n||t+n<i||t>i+n)};Ed11y.alignPanel=function(){if(!Ed11y.panelElement){return false}if(Ed11y.options.panelPinTo==="left"){Ed11y.panel.classList.add("ed11y-pin-left")}let s=0;let i=0;if(Ed11y.elements.panelPin){Ed11y.elements.panelPin.forEach(e=>{let t=e.getBoundingClientRect();if(Ed11y.options.panelPinTo==="right"){s=S-t.left>s&&t.left>S/3?S-t.left:s}else{s=t.right>s&&s+t.right<S/3?s+t.right:s}i=t.height>i&&t.height+i<window.innerHeight/2?i+t.height:i})}if(s>0&&s<S-240){Ed11y.panelElement.style.setProperty(Ed11y.options.panelPinTo,s+10+"px");Ed11y.panelElement.style.setProperty("bottom",Ed11y.options.panelOffsetY)}else if(s>0&&s>S-240&&i>0){Ed11y.panelElement.style.setProperty(Ed11y.options.panelPinTo,Ed11y.options.panelOffsetX);Ed11y.panelElement.style.setProperty("bottom",`calc(${Ed11y.options.panelOffsetY} + ${i}px)`)}else{Ed11y.panelElement.style.setProperty(Ed11y.options.panelPinTo,Ed11y.options.panelOffsetX);Ed11y.panelElement.style.setProperty("bottom",Ed11y.options.panelOffsetY)}};Ed11y.positionedFrames=[];Ed11y.alignButtons=function(){if(!Ed11y.jumpList||Ed11y.jumpList.length===0||Ed11y.openTip.button&&Ed11y.scrollPending===0){return}Ed11y.alignPending=true;if(Ed11y.options.fixedRoots){Ed11y.positionedFrames=[];Ed11y.options.fixedRoots.forEach(e=>{if(e["framePositioner"]){Ed11y.positionedFrames.push(e["framePositioner"].getBoundingClientRect())}})}let d=0;let r=0;const c=window.scrollY;if(!Ed11y.options.inlineAlerts){Ed11y.jumpList.forEach((e,t)=>{if(!e.result.element.isConnected){Ed11y.forceFullCheck=true;Ed11y.interaction=true;e.style.display="none"}else{}let s=e.result.element.getBoundingClientRect();let i=s.top+c;if(!Ed11y.visible(e.result.element)){const o=Ed11y.firstVisibleParent(e.result.element);s=o?o.getBoundingClientRect():s;i=s.top+c}let n=s.left;if(e.result.element.tagName==="IMG"){i=i+10;n=n+10}else{n=Ed11y.options.inlineAlerts?n-34:n}if(e.result.fixedRoot&&Ed11y.positionedFrames[e.result.fixedRoot]){i=i+Ed11y.positionedFrames[e.result.fixedRoot].top;n=n+Ed11y.positionedFrames[e.result.fixedRoot].left}if(e.result.element.tagName==="IMG"){i=i+10;n=n+10}else{n=Ed11y.options.inlineAlerts?n-34:n}if(e.result.scrollableParent){Ed11y.jumpList[t].bounds=e.result.scrollableParent.getBoundingClientRect();if(n<Ed11y.jumpList[t].bounds.left){n=Ed11y.jumpList[t].bounds.left}else if(n+40>Ed11y.jumpList[t].bounds.right){n=Ed11y.jumpList[t].bounds.right-40}}else if(e.result.fixedRoot&&Ed11y.positionedFrames[e.result.fixedRoot]){Ed11y.jumpList[t].bounds=Ed11y.positionedFrames[e.result.fixedRoot];if(n<Ed11y.jumpList[t].bounds.left){n=Ed11y.jumpList[t].bounds.left}else if(n+40>Ed11y.jumpList[t].bounds.right){n=Ed11y.jumpList[t].bounds.right-40}}Ed11y.jumpList[t].targetOffset=s;Ed11y.jumpList[t].markTop=i;Ed11y.jumpList[t].markLeft=n})}else{Ed11y.jumpList.forEach(t=>{t.style.setProperty("transform",null);t.style.setProperty("top","initial");t.style.setProperty("left","initial");if(t.style.transform){const s=window.getComputedStyle(t);let e=s.getPropertyValue("transform");e=e.split(",");t.xOffset=parseFloat(e[4]);t.yOffset=parseFloat(e[5])}else{t.xOffset=0;t.yOffset=0}});Ed11y.jumpList.forEach(e=>{e.markOffset=e.getBoundingClientRect();e.markLeft=e.markOffset.left;e.markTop=e.markOffset.top})}Ed11y.jumpList.forEach((e,t)=>{let s=10;let i=e.result.element.tagName==="IMG"?10:-34;if(e.markTop+c<0){s=-1*(e.markTop+c)-6}if(t>0&&u(e.markLeft,e.markTop,Ed11y.jumpList[t-1].markLeft,Ed11y.jumpList[t-1].markTop)||t>1&&u(e.markLeft,e.markTop,Ed11y.jumpList[t-2].markLeft,Ed11y.jumpList[t-2].markTop)||t>2&&u(e.markLeft,e.markTop,Ed11y.jumpList[t-3].markLeft,Ed11y.jumpList[t-3].markTop)){s=s+14+d;i=14+r}let n=0;let o=S;if(e.result.scrollableParent){const a=e.result.scrollableParent.getBoundingClientRect();n=a.left;o=n+a.width}else if(e.result.fixedRoot&&Ed11y.positionedFrames[e.result.fixedRoot]){n=Ed11y.positionedFrames[e.result.fixedRoot].left;o=Ed11y.positionedFrames[e.result.fixedRoot].right}let l=false;if(e.markLeft+i-n<44){i=44-e.markLeft+i+n;l=true}else if(e.markLeft+i+80>o){l=true;i=o-i-e.markLeft-100}else if(s!==0){l=true}if(!Ed11y.options.inlineAlerts){if(l){e.style.transform=`translate(${e.markLeft+i}px, ${e.markTop+s}px)`}else{e.style.transform=`translate(${e.markLeft}px, ${e.markTop}px)`}}else{y(e,i,s)}e.nudgeLeft=i;e.nudgeTop=s;d=s;r=i});if(!Ed11y.options.inlineAlerts){Ed11y.jumpList.forEach(e=>{if(e.result.scrollableParent){if(!!e.bounds&&(e.targetOffset.top-e.bounds.top<0||e.targetOffset.top-e.bounds.bottom>0)&&!e.matches(':focus, :focus-within, [data-ed11y-open="true"]')){e.classList.add("ed11y-offscreen");e.style.transform="translate(0px, -50px)";e.style.pointerEvents="none";if(e.getAttribute("data-ed11y-open")==="true"){e.setAttribute("data-ed11y-action","shut")}}else{e.classList.remove("ed11y-offscreen");e.style.pointerEvents="auto"}}else if(e.result.fixedRoot&&Ed11y.positionedFrames[e.result.fixedRoot]){if(!!e.bounds&&(e.targetOffset.top<-40||e.targetOffset.top+e.bounds.top-e.bounds.bottom>-10)&&!e.matches(':focus, :focus-within, [data-ed11y-open="true"]')){e.classList.add("ed11y-offscreen");e.style.transform="translate(0px, -50px)";e.style.pointerEvents="none";if(e.getAttribute("data-ed11y-open")==="true"){e.setAttribute("data-ed11y-action","shut")}}else{e.classList.remove("ed11y-offscreen");e.style.pointerEvents="auto"}}else{e.classList.remove("ed11y-offscreen");e.style.pointerEvents="auto"}})}Ed11y.jumpList?.forEach(e=>{e.classList.remove("ed11y-preload")})};Ed11y.paintReady=function(){for(const[e,t]of Object.entries(Ed11y.theme)){document.documentElement.style.setProperty("--ed11y-"+e,t)}if(document.querySelector("body")){Ed11y.attachCSS(document.querySelector("body"))}Ed11y.roots.forEach(e=>{if(Ed11y.options.shadowComponents){e.querySelectorAll(Ed11y.options.shadowComponents)?.forEach(e=>{if(e.shadowRoot){Ed11y.attachCSS(e.shadowRoot)}})}});Ed11y.bodyStyle=true};Ed11y.alignTip=function(e,t,s=0,i=false){if(!t){return}let n=t.shadowRoot.querySelector(".arrow");let o=n.nextElementSibling;let l=s-1;if(s>0){window.setTimeout(function(){requestAnimationFrame(()=>Ed11y.alignTip(e,t,l,i))},200/l,e,t,l,i)}if(i){window.setTimeout(()=>{t.style.setProperty("opacity","1")},140,t,o)}const a=e.getRootNode().host;const d=e.dataset.ed11yResult;const r=Ed11y.results[d];const c=window.scrollY;let y=Ed11y.options.inlineAlerts?window.scrollX:0;let u=e.getBoundingClientRect();let p=u.width;let h=u.left+y;let m=u.top+c;let E=c;let f=0;let g=S;let b=window.innerHeight+c;let w=b;if(!Ed11y.options.inlineAlerts&&r.scrollableParent){let e=r.scrollableParent.getBoundingClientRect();if(e.width>0){f=Math.max(0,e.left);g=Math.min(g,e.width-30);b=e.bottom+c;E=e.top+c;w=e.top+r.scrollableParent.scrollHeight}}else if(a.dataset.ed11yHiddenResult==="true"||!(Ed11y.visible(a)||u.top===0&&u.left===0)){const P=Ed11y.firstVisibleParent(a.result.element);if(P){u=P.getBoundingClientRect();h=u.left;m=u.top}else{o.style.setProperty("max-width","none")}p=S>800?38:33}document.documentElement.style.setProperty("--ed11y-buttonWidth",p+"px");o.style.setProperty("max-width",`min(${g>280?g:280}px, 90vw)`);const v=Math.min(S,f+g);t.style.setProperty("top",u.top+c+"px");t.style.setProperty("left",u.left+y+"px");const x=o.offsetWidth;const k=o.offsetHeight;let C="under";if(m===0&&h===0){C="whompwhomp"}else if(m+k+c+p+22>b){if(v>p+x+h+30&&E+k+30<b){C="right"}else if(m-k-15>E){C="above"}else if(f<h-(p+x+30)&&E+k+30<b){C="left"}else if(m+k+p>w){C="above"}}n.dataset.direction=C;let T=0;let A=0;const L=function(e,t,s,i){let n=e-(t+s+p);if(n<0){if(i==="horizontal"&&t+n<0){return Math.max(0-t,4-s)}return Math.max(n,p+10-s)}return 0};switch(C){case"under":T=L(v,h,x,"horizontal");n.style.setProperty("top",p+"px");n.style.setProperty("right","auto");n.style.setProperty("bottom","auto");n.style.setProperty("left",p/2-10+"px");o.style.setProperty("top",p+10+"px");o.style.setProperty("right","auto");o.style.setProperty("bottom","auto");o.style.setProperty("left","-4px");break;case"above":T=L(v,h,x,"horizontal");n.style.setProperty("top","auto");n.style.setProperty("right","auto");n.style.setProperty("bottom","2px");n.style.setProperty("left",p/2-10+"px");o.style.setProperty("top","auto");o.style.setProperty("right","auto");o.style.setProperty("bottom","12px");o.style.setProperty("left","-4px");break;case"right":A=L(b,m,k,"vertical");n.style.setProperty("top",p/2-10+"px");n.style.setProperty("right","auto");n.style.setProperty("bottom","auto");n.style.setProperty("left",p+"px");o.style.setProperty("top","-4px");o.style.setProperty("right","auto");o.style.setProperty("bottom","auto");o.style.setProperty("left",p+10+"px");break;case"left":A=L(b,m,k,"vertical");n.style.setProperty("top",p/2-10+"px");n.style.setProperty("right","0");n.style.setProperty("bottom","auto");n.style.setProperty("left","auto");o.style.setProperty("top","-4px");o.style.setProperty("right","10px");o.style.setProperty("bottom","auto");o.style.setProperty("left","auto");break;case"whompwhomp":A=L(b,m,k,"horizontal");n.style.setProperty("top","0");n.style.setProperty("right","0");n.style.setProperty("bottom","0");n.style.setProperty("left","0");o.style.setProperty("top",`calc(50vh - ${x/2}px)`);o.style.setProperty("right","auto");o.style.setProperty("bottom","auto");o.style.setProperty("left",`calc(50vh - ${k/2}px)`);break}if(T||A){o.style.setProperty("transform",`translate(${T}px, ${A}px)`)}else{o.style.setProperty("transform","none")}Ed11y.alignHighlights()};Ed11y.togglePanel=function(){Ed11y.ignoreAll=false;if(!Ed11y.doubleClickPrevent){if(Ed11y.running!==true){Ed11y.running=true;if(Ed11y.panel.classList.contains("ed11y-shut")===true){Ed11y.onLoad=false;Ed11y.incremental=false;Ed11y.showPanel=true;if(Ed11y.dismissedCount>0&&Ed11y.warningCount===0&&Ed11y.errorCount===0){Ed11y.options.showDismissed=false;Ed11y.toggleShowDismissals()}else{Ed11y.checkAll()}Ed11y.options.userPrefersShut=false;localStorage.setItem("editoria11yShow","1")}else{Ed11y.panelToggleTitle.textContent=Ed11y.totalCount>0?Ed11y.M.buttonShowAlerts:Ed11y.M.buttonShowNoAlert;Ed11y.options.showDismissed=false;Ed11y.reset();Ed11y.options.userPrefersShut=true;localStorage.setItem("editoria11yShow","0")}}}Ed11y.doubleClickPrevent=true;window.setTimeout(function(){Ed11y.doubleClickPrevent=false},200);return false};const r=function(){let d=Ed11y.panel.querySelector("#ed11y-outline");if(Ed11y.headingOutline.length){d.innerHTML="";Ed11y.headingOutline.forEach((s,t)=>{if(Ed11y.options.inlineAlerts){let e=document.createElement("ed11y-element-heading-label");e.classList.add("ed11y-element","ed11y-element-heading");e.dataset.ed11yHeadingOutline=t.toString();e.setAttribute("id","ed11y-heading-"+t);e.setAttribute("tabindex","-1");s[0].insertAdjacentElement("afterbegin",e);Ed11y.attachCSS(e.shadowRoot)}let e=s[1];let i=10*e-10;let n=document.createElement("li");n.classList.add("level"+e);n.style.setProperty("margin-left",i+"px");let o=document.createElement("strong");o.textContent=`H${e}: `;let l=document.createElement("span");l.textContent=Ed11y.computeText(s[0]);let a=document.createElement("a");if(Ed11y.options.inlineAlerts){a.setAttribute("href","#ed11y-heading-"+t);n.append(a);a.append(o);a.append(l)}else{n.append(o);n.append(l)}if(s[2]){let e=!s[3]?"ed11y-error":"ed11y-warning";n.classList.add(e);let t=document.createElement("em");t.classList.add("ed11y-small");t.textContent=" "+s[2];if(Ed11y.options.inlineAlerts){a.append(t)}else{n.append(t)}}d.append(n)})}else{d.innerHTML="<p><em>No heading structure found.</em></p>"}};Ed11y.alignAlts=function(){Ed11y.findElements("altMark","ed11y-element-alt");Ed11y.elements.altMark?.forEach(e=>{let t=e.dataset.ed11yImg;e.style.setProperty("transform",null);e.style.setProperty("height",null);e.style.setProperty("width",null);let s=Ed11y.imageAlts[t][0];if(s.tagName!=="IMG"){s=s.querySelector("img")}let i=e.getBoundingClientRect();let n=s.getBoundingClientRect();let o=n.left-i.left;let l=getComputedStyle(s).height;l=l==="auto"?s.offsetHeight:Math.max(s.offsetHeight,parseInt(l));e.style.setProperty("transform",`translate(${o}px, 0px)`);e.style.setProperty("height",`${l}px`);e.style.setProperty("width",`${s.offsetWidth}px`)})};const c=function(){let e=Ed11y.panel.querySelector("#ed11y-alt-list");if(Ed11y.imageAlts.length){e.innerHTML="";Ed11y.imageAlts.forEach((t,s)=>{if(Ed11y.options.inlineAlerts){let e=document.createElement("ed11y-element-alt");e.classList.add("ed11y-element");e.dataset.ed11yImg=s.toString();e.setAttribute("id","ed11y-alt-"+s);e.setAttribute("tabindex","-1");t[0].insertAdjacentElement("beforebegin",e)}let i=document.createElement("span");i.textContent=t[2];let n=document.createElement("li");n.classList.add(t[3]);let o=document.createElement("img");o.setAttribute("src",t[1]);o.setAttribute("alt","");if(Ed11y.options.inlineAlerts){let e=document.createElement("a");e.href="#ed11y-alt-"+s;e.classList.add("alt-parent");n.append(e);e.append(o);e.append(i)}else{n.classList.add("alt-parent");n.append(o);n.append(i)}e.append(n)});Ed11y.alignAlts()}else{const t=document.createElement("p");const s=document.createElement("em");s.textContent=Ed11y.M.noImagesFound;t.appendChild(s);e.innerHTML="";e.appendChild(t)}};Ed11y.visualizing=false;Ed11y.visualize=function(){if(!Ed11y.panel){return}if(Ed11y.visualizing){Ed11y.visualizing=false;Ed11y.panel.querySelector("#ed11y-visualize .ed11y-sr-only").textContent=Ed11y.M.buttonToolsContent;Ed11y.panel.querySelector("#ed11y-visualize").setAttribute("data-ed11y-pressed","false");Ed11y.panel.querySelector("#ed11y-visualizers").setAttribute("hidden","true");Ed11y.findElements("reset","ed11y-element-heading-label, ed11y-element-alt");Ed11y.elements.reset?.forEach(e=>{e.remove()});return}Ed11y.pauseObservers();Ed11y.visualizing=true;Ed11y.panel.querySelector("#ed11y-visualize .ed11y-sr-only").textContent=Ed11y.M.buttonToolsActive;Ed11y.panel.querySelector("#ed11y-visualize").setAttribute("data-ed11y-pressed","true");Ed11y.panel.querySelector("#ed11y-visualizers").removeAttribute("hidden");c();r();Ed11y.resumeObservers()};Ed11y.buildJumpList=function(){Ed11y.jumpList=[];Ed11y.pauseObservers();Ed11y.results.forEach((e,t)=>{let s=e.element.getBoundingClientRect().top;if(!s){const i=Ed11y.firstVisibleParent(e.element);if(i){s=i.getBoundingClientRect().top}}s=s+window.scrollY;if(Ed11y.options.fixedRoots){const n=e.element.closest("[data-ed11y-root]");Ed11y.results[t].fixedRoot=n.dataset.ed11yRoot}Ed11y.results[t].scrollableParent=d(e.element);if(Ed11y.results[t].scrollableParent){s=s*1e-6}Ed11y.results[t].sortPos=s});Ed11y.results.sort((e,t)=>t.sortPos-e.sortPos);Ed11y.results?.forEach(function(e,t){if(!Ed11y.results[t].dismissalStatus||Ed11y.options.showDismissed){Ed11y.result(e,t)}});Ed11y.jumpList.forEach((e,t)=>{e.dataset.ed11yJumpPosition=`${t}`;const s=`${e.shadowRoot.querySelector(".toggle").getAttribute("aria-label")}, ${t+1} / ${Ed11y.jumpList.length-1}`;e.shadowRoot.querySelector(".toggle").setAttribute("aria-label",s)});let e=new CustomEvent("ed11yResultsPainted");document.dispatchEvent(e);Ed11y.resumeObservers()};let p=1;Ed11y.browserLag=0;const h=(t,s)=>{let i=null;return(...e)=>{window.clearTimeout(i);i=window.setTimeout(()=>{t.apply(null,e)},s+Ed11y.browserLag)}};const m=function(e,t,s=10){return e.left-s<=t.right&&t.left-s<=e.right&&e.top-s<=t.bottom&&t.top-s<=e.bottom};Ed11y.activeRange=false;Ed11y.rangeChange=function(e){let t=e?e:window.getSelection()?.anchorNode;const s=t&&t.parentNode&&typeof t.parentNode==="object"&&typeof t.parentNode.matches==="function";if(!t||s&&(t.parentNode.matches(Ed11y.options.checkRoots)||!t.parentNode.matches(Ed11y.options.checkRoots)&&t.parentNode.matches('div[contenteditable="true"]'))){Ed11y.activeRange=false;return false}if(s){const n=t.parentNode.closest("p, td, th, li, h2, h3, h4, h5, h6");if(n){t=n}}const i=document.createRange();if(typeof t==="object"){i.setStartBefore(t);i.setEndAfter(t)}if(typeof i!=="object"||typeof i.getBoundingClientRect!=="function"){if(Ed11y.activeRange){Ed11y.activeRange=false;return true}else{return false}}else{let e=Ed11y.activeRange&&i.startContainer===Ed11y.activeRange.startContainer&&i.startOffset===Ed11y.activeRange.startOffset;Ed11y.activeRange=i;return!e}};Ed11y.checkEditableIntersects=function(e=false){if(!e&&!document.querySelector("[contenteditable]:focus, [contenteditable] :focus")){Ed11y.jumpList?.forEach(e=>{e.classList.remove("intersecting")});return}if(!Ed11y.activeRange){Ed11y.jumpList?.forEach(e=>{e.classList.remove("intersecting")});return}Ed11y.jumpList?.forEach(e=>{const t=e.result.fixedRoot&&Ed11y.positionedFrames[e.result.fixedRoot]?Ed11y.positionedFrames[e.result.fixedRoot]:{top:0,left:0};const s=Ed11y.activeRange.getBoundingClientRect();const i={};i.top=s.top+t.top;i.left=s.left+t.left;i.bottom=s.bottom+t.top;i.right=s.right+t.left;const n=e.shadowRoot.querySelector(".toggle");if(m(i,n.getBoundingClientRect(),0)){if(!n.classList.contains("was-intersecting")){e.classList.add("intersecting");n.classList.add("intersecting")}}else{e.classList.remove("intersecting","was-intersecting");n.classList.remove("intersecting","was-intersecting")}})};let E=false;Ed11y.scrollPending=0;Ed11y.updateTipLocations=()=>{if(!E&&Ed11y.scrollPending>0&&!Ed11y.running&&Ed11y.jumpList&&Ed11y.open){E=true;Ed11y.alignButtons();if(Ed11y.openTip.tip){Ed11y.alignTip(Ed11y.openTip.button.shadowRoot.querySelector("button"),Ed11y.openTip.tip)}Ed11y.scrollPending--}E=false;if(Ed11y.scrollPending>0){requestAnimationFrame(()=>Ed11y.updateTipLocations())}};Ed11y.intersectionObservers=function(){Ed11y.elements.editable?.forEach(e=>{e.addEventListener("scroll",function(){if(Ed11y.openTip.button){Ed11y.scrollPending=Ed11y.scrollPending<2?Ed11y.scrollPending+1:Ed11y.scrollPending;requestAnimationFrame(()=>Ed11y.updateTipLocations())}})});document.addEventListener("scroll",function(){if(!Ed11y.options.inlineAlerts&&!Ed11y.openTip.button){Ed11y.scrollPending=Ed11y.scrollPending<2?Ed11y.scrollPending+1:Ed11y.scrollPending;requestAnimationFrame(()=>Ed11y.updateTipLocations())}else if(Ed11y.openTip.button){Ed11y.alignTip(Ed11y.openTip.button.shadowRoot.querySelector("button"),Ed11y.openTip.tip)}},true);Ed11y.selectionChanged=h(()=>{if(Ed11y.rangeChange()){Ed11y.updateTipLocations();Ed11y.checkEditableIntersects()}},100);document.addEventListener("selectionchange",function(){if(!Ed11y.running){Ed11y.selectionChanged()}})};Ed11y.recentlyAddedNodes=new WeakMap;Ed11y.addedNodeReadyToCheck=function(e){if(!Ed11y.recentlyAddedNodes.has(e)){return true}const s=e.textContent.trim().length;if(!s&&Ed11y.recentlyAddedNodes.get(e)>Date.now()-5e3||Ed11y.activeRange&&e.contains(Ed11y.activeRange.startContainer)){return false}else if(e.matches("table")&&e.querySelectorAll("td:not(:empty)")){let t="";if(s){const i=e.querySelectorAll("td:not(:empty)");i.forEach(e=>{t+=e.textContent})}if(!t){return false}else{Ed11y.recentlyAddedNodes.delete(e);return true}}else{Ed11y.recentlyAddedNodes.delete(e);return true}};Ed11y.incrementalAlign=h(()=>{if(!Ed11y.running&&!Ed11y.alignPending){Ed11y.scrollPending++;Ed11y.updateTipLocations();Ed11y.alignPending=false}else{Ed11y.incrementalAlign()}},10);Ed11y.interaction=false;window.addEventListener("keydown",()=>{Ed11y.interaction=true});window.addEventListener("click",()=>{Ed11y.interaction=true});Ed11y.incrementalCheck=h(()=>{if(!Ed11y.running){if(Ed11y.openTip.button||!Ed11y.interaction&&!Ed11y.forceFullCheck){return}Ed11y.interaction=false;Ed11y.running=true;let e=performance.now();Ed11y.incremental=true;if(Ed11y.disabled&&Ed11y.closedByDisable){Ed11y.showPanel=true;Ed11y.closedByDisable=false;Ed11y.disabled=false}Ed11y.checkAll();window.setTimeout(function(){if(Ed11y.visualizing){Ed11y.visualizing=false;Ed11y.visualize()}},500);e=performance.now()-e;p=e>10?10:(p+e)/2;Ed11y.browserLag=p<1?0:p*100+Ed11y.totalCount}else{window.setTimeout(()=>{Ed11y.incrementalCheck()},250)}},250);Ed11y.slowIncremental=h(()=>{Ed11y.interaction=true;Ed11y.incrementalCheck()},1e3);Ed11y.pauseObservers=function(){Ed11y.watching?.forEach(e=>{e.observer.disconnect()})};Ed11y.resumeObservers=function(){Ed11y.watching?.forEach(e=>{e.observer.observe(e.root,e.config)})};const f=function(e){if(typeof e.closest==="function"){if(e.closest("[data-editoria11y-observer]")){return}else{e.dataset.editoria11yObserver="true"}}else{if(typeof e.host!=="function"||e.host.dataset.editoria11yObserver!==undefined){return}else{e.host.dataset.editoria11yObserver="true"}}const t={childList:true,subtree:true,characterData:true};const i=function(e){if(!e||e.nodeType!==1||!e.isConnected||e.closest("script, link, head, .ed11y-wrapper, .ed11y-style, .ed11y-element")){return 0}if(Ed11y.options.inlineAlerts){return 1}if(!e.matches("[contenteditable] *")){return 0}if(Ed11y.options.inlineAlerts){return true}const t="table, h1, h2, h3, h4, h5, h6, blockquote";if(!Ed11y.options.inlineAlerts&&!e.matches(e.matches(t))&&e.matches("[contenteditable] *")){if(e.matches("table *")){e=e.closest("table")}else if(!e.matches(t)){e=e.querySelector(t)}}if(e&&e.matches(t)){Ed11y.recentlyAddedNodes.set(e,Date.now());Ed11y.incrementalAlign();return 0}return 1};const s=e=>{let t=0;for(const s of e){if(s.type==="characterData"&&s.target.parentElement&&s.target.parentElement.matches("[contenteditable] *")){Ed11y.incrementalAlign();Ed11y.slowIncremental();return}else if(s.type==="childList"){if(s.removedNodes.length>0){t+=1}else if(s.addedNodes.length>0){s.addedNodes.forEach(e=>{t+=i(e)})}}}if(!t){return}window.setTimeout(function(){Ed11y.incrementalAlign();Ed11y.alignPending=false;Ed11y.incrementalCheck()},0)};const n=new MutationObserver(s);n.observe(e,t);Ed11y.watching.push({observer:n,root:e,config:t});document.addEventListener("readystatechange",()=>{window.setTimeout(function(){Ed11y.scrollPending++;Ed11y.updateTipLocations()},100)});window.setTimeout(function(){Ed11y.scrollPending++;Ed11y.updateTipLocations()},1e3)};Ed11y.openTip={button:false,tip:false};Ed11y.lastOpenTip=-1;Ed11y.viaJump=false;Ed11y.alertOnInvisibleTip=function(e,t){let s=100;if(Ed11y.options.hiddenHandlers.length>0&&!!t.closest(Ed11y.options.hiddenHandlers)){s=333;document.dispatchEvent(new CustomEvent("ed11yShowHidden",{detail:{result:e.getAttribute("data-ed11y-result")}}))}const i=t.closest("details");if(i&&!i.open){i.open=true;s=333}window.setTimeout((s,i)=>{Ed11y.message.textContent="";let e=false;let t;if(Ed11y.options.checkVisible&&!Ed11y.visible(i)){s.dataset.ed11yHiddenResult="true";e=Ed11y.firstVisibleParent(i);t=Ed11y.M.jumpedToInvisibleTip}else if(i.closest('[aria-hidden="true"]')){e=i.closest('[aria-hidden="true"]');e=e.closest(':not([aria-hidden="true"])');t=Ed11y.M.jumpedToAriaHiddenTip}if(e){const o=Ed11y.openTip.tip?.shadowRoot.querySelector(".ed11y-tip-alert");o.textContent=t}if(Ed11y.viaJump){let e=window.innerHeight>900||window.innerWidth>800&&window.innerHeight>600?"center":"start";let t=Ed11y.options.inlineAlerts?s:i;if(s.dataset.ed11yHiddenResult||!Ed11y.visible(t)){t=Ed11y.firstVisibleParent(i)}if(t&&typeof t.scrollIntoView==="function"){t.scrollIntoView({block:e,behavior:"instant"})}else{Ed11y.raceCrash();return false}}if(!Ed11y.options.inlineAlerts){Ed11y.editableHighlighter(s.dataset.ed11yResult,true,e)}else{if(e){e.classList.add("ed11y-hidden-highlight")}}let n=document.querySelector('ed11y-element-tip[data-ed11y-open="true"]');if(!n){s.setAttribute("data-ed11y-action","open");if(Ed11y.viaJump){window.setTimeout(()=>{let e=document.querySelector('ed11y-element-tip[data-ed11y-open="true"]');if(Ed11y.viaJump){e?.shadowRoot.querySelector(".title").focus()}},100)}}else{if(Ed11y.viaJump){window.setTimeout(()=>{n?.shadowRoot.querySelector(".title").focus()},100,n)}}Ed11y.viaJump=false},s,e,t)};let g=false;Ed11y.raceCrash=function(){if(g){return}g=true;Ed11y.reset();Ed11y.showPanel=true;Ed11y.checkAll();window.setTimeout(function(){if(Ed11y.results.length>0&&g){Ed11y.jumpTo(1);g=false}},100,g)};Ed11y.jumpTo=function(e=1){if(!Ed11y.open){return false}Ed11y.viaJump=true;let t=Ed11y.jumpList.length-1;let s=Ed11y.lastOpenTip+e;if(s<0){Ed11y.nextText=Ed11y.M.buttonFirstContent;s=t}else if(s>t){s=0;Ed11y.nextText=Ed11y.M.buttonNextContent}else{Ed11y.nextText=Ed11y.M.buttonNextContent}Ed11y.lastOpenTip=s;window.setTimeout(function(){Ed11y.panelJumpNext.querySelector(".ed11y-sr-only").textContent=Ed11y.nextText},250);Ed11y.resetClass(["ed11y-hidden-highlight"]);if(!Ed11y.jumpList){Ed11y.buildJumpList()}let i=Ed11y.jumpList[s];let n=i.getAttribute("data-ed11y-result");let o=Ed11y.results[n];const l=o.element;let a=window.innerHeight>900||window.innerWidth>800&&window.innerHeight>600?"center":"start";let d=Ed11y.options.inlineAlerts?i:l;if(i.dataset.ed11yHiddenResult||!Ed11y.visible(d)){d=Ed11y.firstVisibleParent(l)}if(d&&typeof d.scrollIntoView==="function"){d.scrollIntoView({block:a,behavior:"instant"})}else{Ed11y.raceCrash();return false}i.setAttribute("data-ed11y-action","open");Ed11y.scrollPending=2;Ed11y.updateTipLocations()};Ed11y.windowResize=function(){S=window.innerWidth;if(Ed11y.panel?.classList.contains("ed11y-active")===true){Ed11y.alignAlts();Ed11y.alignButtons()}if(Ed11y.openTip.button){Ed11y.alignTip(Ed11y.openTip.button.shadowRoot.querySelector("button"),Ed11y.openTip.tip)}Ed11y.alignPanel()};const b=document.querySelectorAll("[aria-expanded], [aria-controls]");b?.forEach(e=>{e.addEventListener("click",()=>{window.setTimeout(()=>{Ed11y.windowResize()},333)})});Ed11y.escapeWatch=function(e){if(e.keyCode===27){if(e.target.closest("ed11y-element-panel")&&Ed11y.panelToggle.getAttribute("aria-expanded")==="true"){Ed11y.panelToggle.focus();Ed11y.panelToggle.click()}else if(e.target.hasAttribute("data-ed11y-open")){if(Ed11y.openTip.button){Ed11y.toggledFrom.focus();Ed11y.openTip.button.shadowRoot.querySelector("button").click()}}}};document.addEventListener("keyup",function(e){Ed11y.escapeWatch(e)});Ed11y.flattenText=function(e){return e.replace(/[\n\r]+|\s{2,}/g," ").trim()};Ed11y.getText=function(e){return Ed11y.flattenText(e.textContent)};Ed11y.parents=function(e){let t=[];t.push(e);while(e&&!!e.parentElement&&e.parentElement.tagName!=="HTML"){t.push(e.parentElement);e=e.parentElement}return t};Ed11y.computeAriaLabel=function(e,t=0){if(Ed11y.options.ignoreAriaOnElements&&e.matches(Ed11y.options.ignoreAriaOnElements)){return"noAria"}if(Ed11y.options.ignoreTextInElements&&e.matches(Ed11y.options.ignoreTextInElements)){return""}const s=e.getAttribute("aria-labelledby");if(!t&&s){const i=s.split(/\s+/);if(i.length>0){let s="";i.forEach(e=>{const t=document.querySelector(`#${CSS.escape(e)}`);s+=!t?"":Ed11y.computeText(t,1)});return s}}if(e.hasAttribute("aria-label")&&e.getAttribute("aria-label").trim().length>0){return e.getAttribute("aria-label")}return"noAria"};Ed11y.wrapPseudoContent=function(e,t){const s=e=>{if(e==="none")return"";const t=e.includes("url(")||e.includes("image-set(")?e.match(/\/\s*"([^"]+)"/):e.match(/"([^"]+)"/);return t?t[1]:""};const i=s(window.getComputedStyle(e,":before").getPropertyValue("content"));const n=s(window.getComputedStyle(e,":after").getPropertyValue("content"));return`${i}${t}${n}`};Ed11y.nextTreeBranch=function(t){for(let e=0;e<1e3;e++){if(t.nextSibling()){return t.previousNode()}if(!t.parentNode()){return false}}return false};Ed11y.computeText=function(e,t=0,s=false){let i=Ed11y.computeAriaLabel(e,t);if(i!=="noAria"){return i}let n="";if(e.shadowRoot){const r=e.shadowRoot.querySelectorAll("*");r.forEach(e=>{n+=Ed11y.computeText(e)})}if(!e.children.length){n+=Ed11y.wrapPseudoContent(e,e.textContent);if(!n.trim()&&e.hasAttribute("title")){n=e.getAttribute("title")}return t?n:n.replace(/[\n\r]+|\s{2,}/g," ").trim()}let o=document.createTreeWalker(e,NodeFilter.SHOW_ELEMENT|NodeFilter.SHOW_TEXT);let l=false;let a=false;let d=0;e:while(o.nextNode()){d++;if(o.currentNode.nodeType===Node.TEXT_NODE){if(o.currentNode.parentNode.tagName!=="SLOT"){n+=` ${o.currentNode.nodeValue}`}continue}if(o.currentNode.matches(".ed11y-element")||s&&o.currentNode.matches(Ed11y.options.linkIgnoreSelector)){if(!Ed11y.nextTreeBranch(o)){break e}continue}if(o.currentNode.shadowRoot){const r=o.currentNode.shadowRoot.querySelectorAll("*");r.forEach(e=>{n+=Ed11y.computeText(e)});continue}if(l&&!o.currentNode.closest("a")){if(a===n){n+=l}l=false;a=false}if(o.currentNode.hasAttribute("aria-hidden")&&!(t&&d<3)){if(!Ed11y.nextTreeBranch(o)){break e}continue}let e=Ed11y.computeAriaLabel(o.currentNode,t);if(e!=="noAria"){n+=" "+e;if(!Ed11y.nextTreeBranch(o)){break e}continue}switch(o.currentNode.tagName){case"STYLE":case"NOSCRIPT":if(!Ed11y.nextTreeBranch(o)){break e}continue;case"IMG":if(o.currentNode.hasAttribute("alt")&&!o.currentNode.matches('[role="presentation"]')){n+=o.currentNode.getAttribute("alt")}continue;case"SVG":case"svg":if(o.currentNode.getAttribute("role")==="img"&&o.currentNode.hasAttribute("alt")){n+=Ed11y.wrapPseudoContent(o.currentNode,o.currentNode.getAttribute("alt"));if(!Ed11y.nextTreeBranch(o)){break e}}continue;case"A":if(o.currentNode.hasAttribute("title")){l=o.currentNode.getAttribute("title");a=n}else{l=false;a=false}n+=Ed11y.wrapPseudoContent(o.currentNode,"");break;case"INPUT":n+=Ed11y.wrapPseudoContent(o.currentNode,"");if(o.currentNode.hasAttribute("title")){l=o.currentNode.getAttribute("title")}break;case"SLOT":if(o.currentNode.assignedNodes()){const c=o.currentNode.assignedNodes();c?.forEach(e=>{if(e.nodeType===Node.ELEMENT_NODE){n+=Ed11y.computeText(e)}else if(e.nodeType===Node.TEXT_NODE){n+=Ed11y.flattenText(e.nodeValue)}})}n+=Ed11y.wrapPseudoContent(o.currentNode,"");break;default:n+=Ed11y.wrapPseudoContent(o.currentNode,"");break}}if(l&&!a){n+=" "+l}n=Ed11y.wrapPseudoContent(e,n);if(!n.trim()&&e.hasAttribute("title")){return e.getAttribute("title")}return t?n:n.replace(/[\n\r]+|[\s]{2,}/g," ").trim()};Ed11y.resetClass=function(e){e?.forEach(e=>{let t=e;Ed11y.findElements("reset",`.${t}`);Ed11y.elements.reset?.forEach(e=>{e.classList.remove(t)})})};Ed11y.keyboardClick=function(e){e.preventDefault();let t=e.keyCode;switch(t){case 13:case 32:e.target.click();break}};Ed11y.siblings=function(t){if(t.parentNode===null)return[];return Array.prototype.filter.call(t.parentNode.children,function(e){return e!==t})};Ed11y.nextUntil=function(e,t){let s=e.nextElementSibling;if(s){let e=s.matches(t);if(e){return s}else{s=Ed11y.nextUntil(s,t)}}return s};Ed11y.visibleElement=function(t){if(t){if(!t.checkVisibility({opacityProperty:true,visibilityProperty:true})){return false}let e=window.getComputedStyle(t);return!(t.closest(".sr-only, .visually-hidden")||e.getPropertyValue("z-index")<0||e.getPropertyValue("overflow")==="hidden"&&(t.offsetWidth<10||t.offsetHeight<10))}};Ed11y.visible=function(s){if(!Ed11y.visibleElement(s)){return false}else{let e=Ed11y.parents(s);let t=e=>Ed11y.visibleElement(e);return e.every(t)}};Ed11y.firstVisibleParent=function(e){let t=e.parentElement;if(t){if(!Ed11y.visibleElement(t)){t=Ed11y.firstVisibleParent(t);return t}else{return t}}else{return false}};Ed11y.hiddenElementCheck=function(e){let t=window.getComputedStyle(e);return!(t.getPropertyValue("display")==="none"||t.getPropertyValue("visibility")==="hidden"||e.hasAttribute("aria-hidden")||e.hasAttribute("hidden"))};Ed11y.elementNotHidden=function(s){if(!Ed11y.hiddenElementCheck(s)){return false}else{let e=Ed11y.parents(s);let t=e=>Ed11y.hiddenElementCheck(e);return e.every(t)}};Ed11y.parentLink=function(e){return e.closest("a[href]")};Ed11y.srcMatchesOptions=function(i,n){if(n.length>0&&i?.length>0){let e=n.split(/\s*[\s,]\s*/).map(e=>{return"[src*='"+e+"']"});let t=e.join(", ");let s=Array.from(i);return s.filter(e=>e.matches(t))}else{return[]}};Ed11y.sanitizeForHTML=function(e){let t={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#39;","/":"&#x2F;","`":"&#x60;","=":"&#x3D;"};return String(e).replace(/[&<>"'`=/]/g,function(e){return t[e]})};if(CSS.supports("selector(:has(body))")){Ed11y.initialize()}else{console.warn(Ed11y.M.consoleNotSupported)}}}class Ed11yElementAlt extends HTMLElement{constructor(){super()}connectedCallback(){if(!this.initialized){const i=this.attachShadow({mode:"open"});let e=document.createElement("div");e.classList.add("ed11y-wrapper","ed11y-alt-wrapper");let t=Ed11y.imageAlts[this.dataset.ed11yImg];let s=document.createElement("span");s.textContent=t[2];s.classList.add(t[3]);e.appendChild(s);Ed11y.attachCSS(e);i.appendChild(e);this.initialized=true}}}customElements.define("ed11y-element-alt",Ed11yElementAlt);class Ed11yElementPanel extends HTMLElement{constructor(){super()}template(){return`
    <div class='ed11y-buttonbar'>
      <button id='ed11y-show-hidden' data-ed11y-pressed='false' hidden>
        <svg aria-hidden="true" class="shown" xmlns="http://www.w3.org/2000/svg" width="10" viewBox="9 0 640 512"><path fill="Currentcolor" d="M288 32c-81 0-146 37-193 81C49 156 17 208 3 244c-3 8-3 17 0 25C17 304 49 356 95 399C142.5 443 207 480 288 480s146-37 193-81c47-44 78-95 93-131c3-8 3-17 0-25c-15-36-46-88-93-131C434 69 369 32 288 32zM144 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-64c0 35-29 64-64 64c-7 0-14-1-20-3c-6-2-12 2-12 7c.3 7 1 14 3 21c14 51 66 82 118 68s82-66 68-118c-11-42-48-69-89-71c-6-.2-9 6-7 12c2 6 3 13 3 20z"/></svg>
        <svg aria-hidden="true" class="hidden" xmlns="http://www.w3.org/2000/svg" viewBox="39 0 640 512"><path fill="Currentcolor" d="M39 5C28-3 13-1 5 9S-1 35 9 43l592 464c10 8 26 6 34-4s6-26-4-34L526 387c39-41 66-86 78-118c3-8 3-17 0-25c-15-36-46-88-93-131C466 69 401 32 320 32c-68 0-125 26-169 61L39 5zM223 150C249 126 283 112 320 112c80 0 144 65 144 144c0 25-6 48-17 69L408 295c8-19 11-41 5-63c-11-42-48-69-89-71c-6-0-9 6-7 12c2 6 3 13 3 20c0 10-2 20-7 28l-90-71zM373 390c-16 7-34 10-53 10c-80 0-144-65-144-144c0-7 1-14 1-20L83 162C60 191 44 221 35 244c-3 8-3 17 0 25c15 36 46 86 93 131C175 443 239 480 320 480c47 0 89-13 126-33L373 390z"/></svg>
        <span class="ed11y-sr-only"></span>
      </button>
      <button id='ed11y-visualize' data-ed11y-pressed="false" class='ed11y-panel-fa'>
        <svg aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="10" viewBox="0 10 512 512"><path fill="Currentcolor" d="M152 38c10 9 11 24 2 34l-72 80c-4 5-11 8-17 8s-13-2-18-7L7 113C-2 104-2 88 7 79s25-9 34 0l22 22 55-61c9-10 24-11 34-2zm0 160c10 9 11 24 2 34l-72 80c-4 5-11 8-17 8s-13-2-18-7L7 273c-9-9-9-25 0-34s25-9 35 0l22 22 55-61c9-10 24-11 34-2zM224 96c0-18 14-32 32-32l224 0c18 0 32 14 32 32s-14 32-32 32l-224 0c-18 0-32-14-32-32zm0 160c0-18 14-32 32-32l224 0c18 0 32 14 32 32s-14 32-32 32l-224 0c-18 0-32-14-32-32zM160 416c0-18 14-32 32-32l288 0c18 0 32 14 32 32s-14 32-32 32l-288 0c-18 0-32-14-32-32zM48 368a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"/></svg>
        <span class="ed11y-sr-only"></span>
      </button>
      <div id='ed11y-visualizers' class="content" hidden>
          <details id="ed11y-headings-tab">
              <summary>
                  <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" aria-hidden="true"><path fill="currentColor" d="M0 96C0 78 14 64 32 64l384 0c18 0 32 14 32 32s-14 32-32 32L32 128C14 128 0 114 0 96zM64 256c0-18 14-32 32-32l384 0c18 0 32 14 32 32s-14 32-32 32L96 288c-18 0-32-14-32-32zM448 416c0 18-14 32-32 32L32 448c-18 0-32-14-32-32s14-32 32-32l384 0c18 0 32 14 32 32z"></path></svg> <span class="summary-title"></span>
              </summary>
              <div class="details">
                  <span class="details-title"></span>
                  <ul id='ed11y-outline'></ul>
              </div>
          </details>
          <details id="ed11y-alts-tab">
            <summary>
                <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" viewBox="0 0 576 512"><path fill="currentColor" d="M160 80l352 0c9 0 16 7 16 16l0 224c0 8.8-7.2 16-16 16l-21 0L388 179c-4-7-12-11-20-11s-16 4-20 11l-52 80-12-17c-5-6-12-10-19-10s-15 4-19 10L176 336 160 336c-9 0-16-7-16-16l0-224c0-9 7-16 16-16zM96 96l0 224c0 35 29 64 64 64l352 0c35 0 64-29 64-64l0-224c0-35-29-64-64-64L160 32c-35 0-64 29-64 64zM48 120c0-13-11-24-24-24S0 107 0 120L0 344c0 75 61 136 136 136l320 0c13 0 24-11 24-24s-11-24-24-24l-320 0c-49 0-88-39-88-88l0-224zm208 24a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"></path></svg> <span class="summary-title"></span>
            </summary>
            <div class="details">
                <span class="details-title"></span>
                <ul id='ed11y-alt-list'></ul>
            </div>
        </details>
        </div>
      <button type='button' id='ed11y-toggle'><span class="ed11y-sr-only">Show alerts</span><span class="ed11y-toggle-circle"><span class='icon'><svg class="errors-icon" xmlns="http://www.w3.org/2000/svg" width="10" aria-hidden="true" viewBox="0 0 448 512"><path fill="currentColor" d="M64 32C64 14 50 0 32 0S0 14 0 32L0 64 0 368 0 480c0 18 14 32 32 32s32-14 32-32l0-128 64-16c41-10 85-5 123 13c44.2 22 96 25 142 7l35-13c13-5 21-17 21-30l0-248c0-23-24-38-45-28l-10 5c-46 23-101 23-147 0c-35-18-75-22-114-13L64 48l0-16z"></path></svg><svg class="pass-icon" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" viewBox="-.75 -3.5 10.1699 19.1777"><path fill="currentColor" d="M3.7031,10.5527c-.3633-.6562-.6426-1.1387-.8379-1.4473l-.3105-.4863-.2344-.3574c-.5117-.7969-1.0449-1.4551-1.5996-1.9746.3164-.2617.6113-.3926.8848-.3926.3359,0,.6348.123.8965.3691s.5918.7148.9902,1.4062c.4531-1.4727,1.0293-2.8691,1.7285-4.1895.3867-.7188.7314-1.2021,1.0342-1.4502s.7041-.3721,1.2041-.3721c.2656,0,.5938.041.9844.123-1.0039.8086-1.8066,1.7695-2.4082,2.8828s-1.3789,3.0762-2.332,5.8887Z"/></svg><svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" class="close-icon" viewBox="0 0 384 512"><path fill="currentColor" d="M343 151c13-13 13-33 0-46s-33-13-45 0L192 211 87 105c-13-13-33-13-45 0s-13 33 0 45L147 256 41 361c-13 13-13 33 0 45s33 13 45 0L192 301 297 407c13 13 33 13 45 0s13-33 0-45L237 256 343 151z"></path></svg></span></span></button>
      <button class='ed11y-jump next' data-ed11y-goto='0' aria-haspopup="dialog"><svg class="hover-icon" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="11" viewBox="0 -15 90 120"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" d="m30 00 50 50-50 50" stroke-width="18"></path></svg><span class='toggle-count'></span><span class='jump-next ed11y-sr-only'></span></button>
     </div>
    </div>
    <div id="ed11y-message" aria-live="polite"></div>
    `}connectedCallback(){if(!this.initialized&&typeof Ed11y!=="undefined"){this.style.setProperty("outline","0");this.classList.add("ed11y-element");const e=this.attachShadow({mode:"open"});const t=document.createElement("aside");t.setAttribute("id","ed11y-panel");t.classList.add("ed11y-wrapper","ed11y-panel-wrapper","ed11y-pass","ed11y-preload");t.innerHTML=this.template();e.appendChild(t);Ed11y.panel=t;Ed11y.panelElement=this;Ed11y.panelToggle=t.querySelector("#ed11y-toggle");Ed11y.panelToggleTitle=t.querySelector("#ed11y-toggle .ed11y-sr-only");Ed11y.panelCount=t.querySelector(".toggle-count");Ed11y.panelJumpNext=t.querySelector(".ed11y-jump.next");Ed11y.panelJumpNext.addEventListener("click",this.jumpTo);Ed11y.showDismissed=t.querySelector("#ed11y-show-hidden");Ed11y.message=t.querySelector("#ed11y-message");const s=t.querySelectorAll(".ed11y-buttonbar button");s.forEach(e=>{e.addEventListener("click",this.handleBarClick)});const i=Ed11y.panel.querySelector("#ed11y-alts-tab");const n=Ed11y.panel.querySelector("#ed11y-headings-tab");i.addEventListener("toggle",()=>{if(i.open&&n.open){n.removeAttribute("open")}});n.addEventListener("toggle",()=>{if(i.open&&n.open){i.removeAttribute("open")}});this.initialized=true}}jumpTo(e){e.preventDefault();Ed11y.toggledFrom=e.target.closest("button");if(!Ed11y.open){Ed11y.togglePanel();window.setTimeout(function(){Ed11y.jumpTo(1)},500)}else{Ed11y.jumpTo(1)}}handleBarClick(e){e.preventDefault();Ed11y.message.textContent="";let t=e.currentTarget.getAttribute("id");switch(t){case"ed11y-toggle":Ed11y.togglePanel();break;case"ed11y-show-hidden":Ed11y.toggleShowDismissals();break;case"ed11y-visualize":if(!Ed11y.open){Ed11y.togglePanel()}Ed11y.visualize();break;default:break}}}customElements.define("ed11y-element-panel",Ed11yElementPanel);class Ed11yElementHeadingLabel extends HTMLElement{constructor(){super()}connectedCallback(){if(!this.initialized){const o=this.attachShadow({mode:"open"});let e=document.createElement("div");e.classList.add("ed11y-wrapper","ed11y-heading-wrapper");let t=this.dataset.ed11yHeadingOutline;let s=Ed11y.headingOutline[t];e.innerHTML="H"+s[1];let i=!!s[2];e.classList.add("issue"+i);let n=Math.max(52-8*s[1],12);e.style.setProperty("font-size",n+"px");o.appendChild(e);this.initialized=true}}}customElements.define("ed11y-element-heading-label",Ed11yElementHeadingLabel);class Ed11yElementResult extends HTMLElement{constructor(){super()}connectedCallback(){if(!this.initialized){this.open=false;this.racing=false;this.style.setProperty("outline","0px solid transparent");const t=this.attachShadow({mode:"open"});this.resultID=this.dataset.ed11yResult;this.result=Ed11y.results[this.resultID];this.wrapper=document.createElement("div");this.dismissable=this.result.dismissalKey!==false;this.dismissed=!!this.result.dismissalStatus;this.wrapper.classList.add("ed11y-wrapper","ed11y-result-wrapper");this.wrapper.classList.add("ed11y-result");this.toggle=document.createElement("button");this.toggle.setAttribute("class","toggle");let e=this.dismissable?Ed11y.M.toggleManualCheck:Ed11y.M.toggleAlert;this.toggle.setAttribute("aria-label",Ed11y.M.toggleAriaLabel(e));this.toggle.setAttribute("aria-expanded","false");this.toggle.setAttribute("aria-haspopup","dialog");this.toggle.setAttribute("data-ed11y-result",this.dataset.ed11yResult);this.toggle.setAttribute("data-ed11y-ready","false");this.toggle.setAttribute("data-ed11y-race","false");if(!Ed11y.options.inlineAlerts){this.toggle.style.setProperty("font-size","16px")}if(this.dismissed){this.toggle.innerHTML='<svg aria-hidden="true" width="10" class="hidden" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path fill="Currentcolor" d="M39 5C28-3 13-1 5 9S-1 35 9 43l592 464c10 8 26 6 34-4s6-26-4-34L526 387c39-41 66-86 78-118c3-8 3-17 0-25c-15-36-46-88-93-131C466 69 401 32 320 32c-68 0-125 26-169 61L39 5zM223 150C249 126 283 112 320 112c80 0 144 65 144 144c0 25-6 48-17 69L408 295c8-19 11-41 5-63c-11-42-48-69-89-71c-6-0-9 6-7 12c2 6 3 13 3 20c0 10-2 20-7 28l-90-71zM373 390c-16 7-34 10-53 10c-80 0-144-65-144-144c0-7 1-14 1-20L83 162C60 191 44 221 35 244c-3 8-3 17 0 25c15 36 46 86 93 131C175 443 239 480 320 480c47 0 89-13 126-33L373 390z"/></svg>';this.toggle.classList.add("dismissed");if(this.result.dismissalStatus!=="ok"){this.toggle.classList.add("notok")}else{this.toggle.classList.add("ok")}}else if(this.dismissable){this.toggle.classList.add("dismissable")}this.wrapper.appendChild(this.toggle);this.toggle.addEventListener("click",this.toggleClick);this.toggle.addEventListener("focus",this.handleFocus);this.toggle.addEventListener("mouseover",this.handleHover);this.tipNeedsBuild=true;Ed11y.attachCSS(this.wrapper);t.appendChild(this.wrapper);this.initialized=true}}handleHover(e){e.preventDefault();let t=this.getRootNode().host;if(!this.classList.contains("intersecting")&&t.open!==true&&t.racing===false){this.open=true;t.racing=true;t.toggleTip(true);Ed11y.toggledFrom=this;window.setTimeout(function(){t.racing=false},250,t)}}handleFocus(){let e=this.getRootNode().host;if(this.getRootNode().host.classList.contains("ed11y-offscreen")){e.result.element.scrollIntoView();Ed11y.alignButtons()}}toggleClick(e){e.preventDefault();let t=this.getRootNode().host;if(t.racing===false){t.racing=true;Ed11y.toggledFrom=this;let e=t.getAttribute("data-ed11y-open")==="false"?"open":"close";t.setAttribute("data-ed11y-action",e);if(e==="open"){window.setTimeout(function(){let e=document.querySelector('ed11y-element-tip[data-ed11y-open="true"]');e?.shadowRoot.querySelector(".title").focus()},500)}window.setTimeout(function(){t.racing=false},250,t)}}closeOtherTips(){if(Ed11y.openTip.button){Ed11y.openTip.button.setAttribute("data-ed11y-action","close")}}buildTip(){this.tipNeedsBuild=false;let e=document.createElement("ed11y-element-tip");e.result=this.result;e.setAttribute("data-ed11y-result",this.resultID);e.classList.add("ed11y-element");e.style.setProperty("opacity","0");Ed11y.options.panelAttachTo.insertAdjacentElement("beforeend",e);this.tip=e}toggleTip(e){if(this.tipNeedsBuild){this.buildTip()}this.toggle.setAttribute("aria-expanded",e);let t=this.dismissable?"ed11y-ring-yellow":"ed11y-ring-red";if(Ed11y.options.inlineAlerts){Ed11y.resetClass(["ed11y-hidden-highlight","ed11y-ring-red","ed11y-ring-yellow","ed11y-warning-block","ed11y-error-block","ed11y-warning-inline","ed11y-error-inline"])}else{Ed11y.editableHighlighter(this.resultID,e)}if(e===true){this.tip.style.setProperty("opacity","0");document.dispatchEvent(new CustomEvent("ed11yPop",{detail:{id:"ed11y-result-"+this.toggle.getAttribute("data-ed11y-result"),result:this.result,tip:this.tip}}));this.closeOtherTips();this.tip.setAttribute("data-ed11y-action","open");if(Ed11y.options.inlineAlerts){this.result.element.classList.add(t)}requestAnimationFrame(()=>Ed11y.alignTip(this.toggle,this.tip,4,true));if(!Ed11y.jumpList){Ed11y.buildJumpList()}Ed11y.lastOpenTip=Number(this.getAttribute("data-ed11y-jump-position"));Ed11y.openTip={button:this,tip:this.tip};this.result.highlight?.style.setProperty("opacity","1")}else{document.dispatchEvent(new CustomEvent("ed11yShut",{detail:{id:"ed11y-result-"+this.toggle.getAttribute("data-ed11y-result")}}));this.tip.setAttribute("data-ed11y-action","shut");this.result.highlight?.style.setProperty("opacity","0");Ed11y.openTip={button:false,tip:false}}this.setAttribute("data-ed11y-open",e);this.open=e}static get observedAttributes(){return["data-ed11y-action"]}attributeChangedCallback(e,t,s){if(this.initialized){switch(e){case"data-ed11y-action":if(s!=="false"){let e=s==="open";this.setAttribute("data-ed11y-action","false");this.toggleTip(e)}break}}}}customElements.define("ed11y-element-result",Ed11yElementResult);class Ed11yElementTip extends HTMLElement{constructor(){super()}connectedCallback(){if(!this.initialized&&this.result){this.renderOnce()}}renderOnce(){this.initialized=true;this.open=true;this.style.setProperty("opacity","0");this.style.setProperty("outline","0px solid transparent");const e=this.attachShadow({mode:"open"});this.wrapper=document.createElement("div");this.wrapper.setAttribute("role","dialog");this.dismissable=this.result.dismissalKey!==false;this.dismissed=!!this.result.dismissalStatus;this.wrapper.classList.add("ed11y-tip-wrapper","ed11y-wrapper");this.wrapper.setAttribute("aria-label",`${Ed11y.M.issue}
        ${Number.parseInt(this.result.toggle.dataset.ed11yJumpPosition)+1}`);this.addEventListener("mouseover",this.handleHover);Ed11y.attachCSS(this.wrapper);this.tip=document.createElement("div");this.tip.classList.add("tip");let t=document.createElement("div");t.classList.add("content");this.heading=document.createElement("div");this.heading.classList.add("title");this.heading.setAttribute("tabindex","-1");this.heading.innerHTML=Ed11y.M[this.result.test].title;t.append(this.heading);const s=document.createElement("div");s.classList.add("ed11y-tip-alert");this.heading.insertAdjacentElement("afterbegin",s);let i=document.createElement("div");i.innerHTML=this.result.content;t.append(i);if(!Ed11y.options.inlineAlerts||Ed11y.options.editLinks){const c=document.createElement("div");if(!Ed11y.options.inlineAlerts){c.classList.add("ed11y-tip-dismissals");const y=document.createElement("button");const u=document.createElement("span");u.classList.add("ed11y-transfer-icon");u.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" viewBox="0 0 256 512"><path fill="currentColor" d="M0 29C-1 47 12 62 29 64l8 1C71 67 96 95 96 128L96 224l-32 0c-18 0-32 14-32 32s14 32 32 32l32 0 0 96c0 33-26 61-59 64l-8 1C12 450-1 465 0 483s17 31 35 29l8-1c34-3 64-19 85-43c21 24 51 40 85 43l8 1c18 2 33-12 35-29s-12-33-29-35l-8-1C186 445 160 417 160 384l0-96 32 0c18 0 32-14 32-32s-14-32-32-32l-32 0 0-96c0-33 26-61 59-64l8-1c18-2 31-17 29-35S239-1 221 0l-8 1C179 4 149 20 128 44c-21-24-51-40-85-43l-8-1C17-1 2 12 0 29z"/></svg>';y.textContent=Ed11y.M.transferFocus;y.prepend(u);y.classList.add("dismiss","ed11y-transfer-focus");c.append(y);y.addEventListener("click",function(){Ed11y.transferFocus()})}else{c.classList.add("ed11y-custom-edit-links");c.append(Ed11y.options.editLinks.cloneNode(true))}t.append(c)}if(this.dismissable){const p=document.createElement("div");p.classList.add("ed11y-tip-dismissals");const h=document.createElement("span");h.classList.add("ed11y-dismiss-icon");h.innerHTML='<svg aria-hidden="true" class="hidden" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 640 512"><path fill="Currentcolor" d="M39 5C28-3 13-1 5 9S-1 35 9 43l592 464c10 8 26 6 34-4s6-26-4-34L526 387c39-41 66-86 78-118c3-8 3-17 0-25c-15-36-46-88-93-131C466 69 401 32 320 32c-68 0-125 26-169 61L39 5zM223 150C249 126 283 112 320 112c80 0 144 65 144 144c0 25-6 48-17 69L408 295c8-19 11-41 5-63c-11-42-48-69-89-71c-6-0-9 6-7 12c2 6 3 13 3 20c0 10-2 20-7 28l-90-71zM373 390c-16 7-34 10-53 10c-80 0-144-65-144-144c0-7 1-14 1-20L83 162C60 191 44 221 35 244c-3 8-3 17 0 25c15 36 46 86 93 131C175 443 239 480 320 480c47 0 89-13 126-33L373 390z"/></svg>';if(Ed11y.options.showDismissed&&this.dismissed){let e=Ed11y.dismissedAlerts[Ed11y.options.currentPage][this.result.test][this.result.dismissalKey]==="ok";if(e&&Ed11y.options.allowOK||!e){const m=document.createElement("button");const E=document.createElement("span");E.classList.add("ed11y-dismiss-icon");E.innerHTML='<svg aria-hidden="true" class="shown" xmlns="http://www.w3.org/2000/svg" width="10" viewBox="-30 0 640 512"><path fill="Currentcolor" d="M288 32c-81 0-146 37-193 81C49 156 17 208 3 244c-3 8-3 17 0 25C17 304 49 356 95 399C142.5 443 207 480 288 480s146-37 193-81c47-44 78-95 93-131c3-8 3-17 0-25c-15-36-46-88-93-131C434 69 369 32 288 32zM144 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-64c0 35-29 64-64 64c-7 0-14-1-20-3c-6-2-12 2-12 7c.3 7 1 14 3 21c14 51 66 82 118 68s82-66 68-118c-11-42-48-69-89-71c-6-.2-9 6-7 12c2 6 3 13 3 20z"/></svg>';m.classList.add("dismiss");m.textContent=e?Ed11y.M.undismissOKButton:Ed11y.M.undismissHideButton;m.prepend(E);p.append(m);m.addEventListener("click",function(){Ed11y.dismissThis("reset")})}else{const f=document.createElement("div");f.classList.add("dismissed-note");f.textContent=Ed11y.M.undismissNotePermissions;p.append(f)}}else{const g=document.createElement("details");const b=document.createElement("summary");const w=Ed11y.results.filter(e=>e.test===this.result.test).length;const v=w>3&&Ed11y.options.allowHide&&Ed11y.options.allowOK;if(v){g.classList.add("ed11y-bulk-actions","dismiss");b.textContent=Ed11y.M.dismissActions(w);g.appendChild(b);p.appendChild(g)}if(Ed11y.options.allowOK){const x=document.createElement("span");x.setAttribute("aria-hidden","true");x.textContent="✓";const k=document.createElement("button");k.classList.add("dismiss");if(Ed11y.options.syncedDismissals){k.setAttribute("title",Ed11y.M.dismissOkTitle)}k.textContent=Ed11y.M.dismissOkButtonContent;p.prepend(k);if(v){const C=k.cloneNode(true);C.textContent=Ed11y.M.dismissOkAllButton;C.prepend(x.cloneNode(true));g.append(C);C.addEventListener("click",function(){Ed11y.dismissThis("ok",true)})}k.prepend(x);k.addEventListener("click",function(){Ed11y.dismissThis("ok")})}if(Ed11y.options.allowHide){const T=document.createElement("button");T.classList.add("dismiss");if(Ed11y.options.syncedDismissals){T.setAttribute("title",Ed11y.M.dismissHideTitle)}T.textContent=Ed11y.M.dismissHideButtonContent;T.prepend(h.cloneNode(true));p.prepend(T);T.addEventListener("click",function(){Ed11y.dismissThis("hide")});if(v){const A=document.createElement("button");A.classList.add("dismiss");A.textContent=Ed11y.M.dismissHideAllButton;A.prepend(h.cloneNode(true));b.insertAdjacentElement("afterend",A);A.addEventListener("click",function(){Ed11y.dismissThis("hide",true)})}}}t.append(p)}this.tip.append(t);this.navBar=document.createElement("div");this.navBar.classList.add("ed11y-tip-header");this.count=document.createElement("div");this.count.classList.add("ed11y-tip-count");this.count.textContent=`${Ed11y.M.issue} ${Number.parseInt(this.result.toggle.dataset.ed11yJumpPosition)+1} / ${Ed11y.jumpList.length}`;this.navBar.append(this.count);if(Ed11y.jumpList.length>1){this.prev=document.createElement("button");this.prev.classList.add("ed11y-tip-prev");this.prev.setAttribute("aria-label",Ed11y.M.buttonPrevContent);this.prev.setAttribute("title",Ed11y.M.buttonPrevContent);this.prev.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" width="10" viewBox="0 -10 30 120"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" d="m40 100,-50 -50 50-50 50"></path></svg>';this.prev.addEventListener("click",e=>{e.preventDefault();Ed11y.jumpTo(-1)});this.navBar.append(this.prev);this.next=document.createElement("button");this.next.classList.add("ed11y-tip-next");this.next.setAttribute("aria-label",Ed11y.M.buttonNextContent);this.next.setAttribute("title",Ed11y.M.buttonNextContent);this.next.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" viewBox="-10 -10 120 120" width="10"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="16" d="m30 00 50 50-50 50"></path></svg>';this.next.addEventListener("click",e=>{e.preventDefault();Ed11y.jumpTo(1)});this.navBar.append(this.next)}this.help=document.createElement("details");this.help.classList.add("button");this.helpContent=document.createElement("div");this.helpContent.classList.add("ed11y-tip-help-content");this.helpContent.innerHTML=Ed11y.M.panelHelp;this.help.append(this.helpContent);this.helpToggle=document.createElement("summary");this.helpToggle.textContent="?";this.helpToggle.setAttribute("aria-label",Ed11y.M.panelHelpTitle);this.helpToggle.setAttribute("title",Ed11y.M.panelHelpTitle);this.help.insertAdjacentElement("afterbegin",this.helpToggle);this.navBar.append(this.help);let n=document.createElement("button");n.setAttribute("aria-label",Ed11y.M.closeTip);n.setAttribute("title",Ed11y.M.closeTip);n.classList.add("close");n.innerHTML='<svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" viewBox="0 0 384 512"><path fill="currentColor" d="M343 151c13-13 13-33 0-46s-33-13-45 0L192 211 87 105c-13-13-33-13-45 0s-13 33 0 45L147 256 41 361c-13 13-13 33 0 45s33 13 45 0L192 301 297 407c13 13 33 13 45 0s13-33 0-45L237 256 343 151z"/></svg>';this.navBar.append(n);this.tip.append(this.navBar);let o=document.createElement("div");o.classList.add("arrow");n.addEventListener("click",e=>{e.preventDefault();if(this.open){let e=document.querySelector('ed11y-element-result[data-ed11y-open="true"]');if(Ed11y.toggledFrom){Ed11y.toggledFrom.focus()}e?.setAttribute("data-ed11y-action","shut");this.setAttribute("data-ed11y-action","shut")}});document.addEventListener("click",e=>{if(this.open&&!e.target.closest("ed11y-element-tip, ed11y-element-result, ed11y-element-panel")){let e=document.querySelector('ed11y-element-result[data-ed11y-open="true"]');e?.setAttribute("data-ed11y-action","shut");this.setAttribute("data-ed11y-action","shut")}});e.appendChild(this.wrapper);let l=document.createElement("div");l.setAttribute("tabIndex","0");let a=document.createElement("div");a.setAttribute("tabindex","0");this.wrapper.appendChild(l);this.wrapper.appendChild(o);this.wrapper.appendChild(this.tip);this.wrapper.appendChild(a);let d=this.wrapper.querySelectorAll('a, button, [tabindex="0"]');let r=d.length;d[0].addEventListener("focus",()=>{d[r-2].focus()});d[r-1].addEventListener("focus",()=>{d[1].focus()});this.initialized=true;this.rendering=false}toggleTip(e){if(e){this.wrapper.classList.add("open");Ed11y.alertOnInvisibleTip(this.result.toggle,this.result.element)}else{this.wrapper.classList.remove("open")}this.setAttribute("data-ed11y-open",e)}static get observedAttributes(){return["data-ed11y-action"]}attributeChangedCallback(e,t,s){if(!this.initialized&&this.result){this.renderOnce()}if(this.initialized){switch(e){case"data-ed11y-action":if(s!=="false"){let e=s==="open";this.open=e;this.setAttribute("data-ed11y-action","false");this.toggleTip(e)}break}}}}customElements.define("ed11y-element-tip",Ed11yElementTip);