# Entity Back Reference

Entity back reference intends to add upon the Drupal Entity API by providing a method to refer back to all entities which point to a current entity. This module adds a service which provides two methods:

- getReferencingFieldList : This method provides a list of all entity reference fields which can point to our current entity, i.e. all reference fields on our application which have the current entity value stored as the target_id.
- loadBackReferencedEntities : This method loads the referencing entites one by one, based on the fields where were returned from getReferencingFieldList to give us the entity objects which have our current entity stored in a target_id.

For example, if we have a custom block entity say A which has been added via reference fields to other entity types, say another custom block type B and also on a content type, say Basic Page, then using the API functions which this module provides we can get the list of all Custom block entites of type B and nodes of type Basic Page on which our current block entity A has been added via a reference field.

This functionality is in reverse of what the referencedEntities() method which provides all entities added in a reference field.

[project page](https://www.drupal.org/project/entity_back_reference).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/search/entity_back_reference).

## Table of contents

- Installation
- Usage
- Maintainers

## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Usage

### Using via custom code:

- This is an example block of code to demonstrate the usage of the functions which this module provides:


```php
<?php
// We are loading a block object.
$blockData = \Drupal::entityTypeManager()->getStorage('block_content')->load($blockId);
if ($blockData instanceof BlockContentInterface) {
    // We want to fetch all reference fields which can reference our current block entity.
    $backRef = \Drupal::service('entity_backReference.backReference_finder')->getReferencingFieldList('block_content', $blockData->bundle());
    /* The method getReferencingFieldList returns an array which contains the key as the $entityTypeId . $entityBundleId of the current block entity and the value as an array of field config objects on which the entity is referenced.
        [
            'block_content_123456' => [
                0 => FieldConfig object 1,
                1 => FieldConfig object 2,
                . => ..
                . => ..
                . => ..
            ]
        ]
    */
    // Check that it is non empty.
    if (!empty($backRef)) {
        // Loop through all the field config where our entity has been referenced.
        foreach ($backRef as $fieldConfig) {
            // We use the other function provided by this module, loadBackReferencedEntities, where we pass the field config & the current block entity ID to get the entities which have the block added in reference field.
            $backRefEntities[] = \Drupal::service('entity_backReference.backReference_finder')->loadBackReferencedEntities($fieldConfig, $blockId);
        }
    }
}
```

## Maintainers

Current maintainers:

- [Sneha Chakraborty (snehachak)](https://www.drupal.org/u/snehachak)

Supporting organizations:

- [accenture](https://www.drupal.org/accenture) Created this module for you!
