<?php

declare(strict_types=1);

namespace Drupal\environment_indicator\Controller;

use Drupal\environment_indicator\Entity\EnvironmentIndicator;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Provides title callbacks for environment indicator switcher routes.
 */
class EnvironmentIndicatorSwitcher {
  use StringTranslationTrait;

  /**
   * Returns the title for the environment indicator switcher list page.
   */
  public function editTitle(EnvironmentIndicator $environment_indicator): string {
    return (string) $this->t('Edit environment indicator switcher: @label', ['@label' => $environment_indicator->label()]);
  }

}
