<?php

namespace Drupal\modeler_api\Plugin;

use Drupal\Core\Plugin\PluginBase;

/**
 * Component wrapper plugin for model owner components that aren't plugins.
 */
class ComponentWrapperPlugin extends PluginBase implements ComponentWrapperPluginInterface {

  /**
   * Creates a new component wrapper plugin instance.
   *
   * @param int $type
   *   The component type.
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   */
  public function __construct(
    protected int $type,
    array $configuration = [],
  ) {
    parent::__construct($configuration, self::PLUGIN_ID, []);
  }

  /**
   * {@inheritdoc}
   */
  public function getType(): int {
    return $this->type;
  }

  /**
   * {@inheritdoc}
   */
  public function getConfiguration(): array {
    return $this->configuration;
  }

}
