<?php

namespace Drupal\modeler_api\Plugin;

/**
 * Interface for component wrapper plugins.
 *
 * Such plugins should only be used for model owner components, that aren't
 * plugins already. That way, they can be wrapped in a plugin and still be
 * handed around the different places.
 */
interface ComponentWrapperPluginInterface {

  public const string PLUGIN_ID = 'modeler_api_component_wrapper';

  /**
   * Gets the component type.
   *
   * @return int
   *   The component type.
   */
  public function getType(): int;

  /**
   * Get the component configuration.
   *
   * @return array
   *   The component configuration.
   */
  public function getConfiguration(): array;

}
