/**
 * @file
 * JavaScript behaviors for time integration.
 */

(function ($, Drupal, once) {

  'use strict';

  // @see https://github.com/jonthornton/jquery-timepicker#options
  Drupal.webform = Drupal.webform || {};
  Drupal.webform.timePicker = Drupal.webform.timePicker || {};
  Drupal.webform.timePicker.options = Drupal.webform.timePicker.options || {};

  /**
   * Attach timepicker fallback on time elements.
   *
   * @type {Drupal~behavior}
   *
   * @prop {Drupal~behaviorAttach} attach
   *   Attaches the behavior to time elements.
   */
  Drupal.behaviors.webformTime = {
    attach: function (context, settings) {
      if (!$.fn.timepicker) {
        return;
      }

      $(once('webformTimePicker', 'input[data-webform-time-format]', context)).each(function () {
        var $input = $(this);
        var options = {};
        options.timeFormat = $input.data('webformTimeFormat');
        if ($input.attr('min')) {
          options.minTime = $input.attr('min');
        }
        if ($input.attr('max')) {
          options.maxTime = $input.attr('max');
        }

        // HTML5 time element steps is in seconds but for the timepicker
        // fallback it needs to be in minutes.
        // Note: The 'datetime' element uses the #date_increment which defaults
        // to 1 (second).
        // @see \Drupal\Core\Datetime\Element\Datetime::processDatetime
        // Only use step if it is greater than 60 seconds.
        if ($input.attr('step') && ($input.attr('step') > 60)) {
          options.step = Math.round($input.attr('step') / 60);
        }
        else {
          options.step = 1;
        }

        // Set step to 'any' to prevent clientside validation issues.
        // @see \Drupal\clientside_validation\Plugin\CvValidator\Step
        // @see https://www.drupal.org/project/clientside_validation/issues/2941434
        $input.attr('step', 'any');

        options = $.extend(options, Drupal.webform.timePicker.options);

        $input.timepicker(options);
      });
    }
  };

})(jQuery, Drupal, once);
